/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.session.PersistentSession;
import com.sk89q.commandbook.session.SessionComponent;
import com.sk89q.commandbook.util.PlayerUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.Depend;
import com.zachsthings.libcomponents.InjectComponent;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import java.util.concurrent.TimeUnit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

@ComponentInformation(friendlyName="Freeze", desc="Blocks a specified player's movement on command")
@Depend(components={SessionComponent.class})
public class FreezeComponent
extends BukkitComponent
implements Listener,
Runnable {
    public static final int MOVE_THRESHOLD = 2;
    private static final int MOVE_THRESHOLD_SQ = 4;
    @InjectComponent
    private SessionComponent sessions;

    public void enable() {
        this.registerCommands(Commands.class);
        CommandBook.registerEvents(this);
        CommandBook.server().getScheduler().scheduleSyncRepeatingTask((Plugin)CommandBook.inst(), (Runnable)this, 40L, 40L);
    }

    public boolean freezePlayer(Player player) {
        FreezeState session = this.sessions.getSession(FreezeState.class, (CommandSender)player);
        boolean previous = session.isFrozen();
        session.freeze(player.getLocation());
        return previous;
    }

    public boolean isFrozen(Player player) {
        return this.sessions.getSession(FreezeState.class, (CommandSender)player).isFrozen();
    }

    public boolean unfreezePlayer(Player player) {
        FreezeState session = this.sessions.getSession(FreezeState.class, (CommandSender)player);
        boolean previous = session.isFrozen();
        session.freeze(null);
        return previous;
    }

    public void run() {
        for (FreezeState frozenState : this.sessions.getSessions(FreezeState.class).values()) {
            Location loc;
            Player player;
            if (!frozenState.isFrozen() || (player = frozenState.getOwner()) == null || !player.isOnline() || !((loc = player.getLocation()).distanceSquared(frozenState.getFreezeLocation()) >= 4.0)) continue;
            loc.setX(frozenState.getFreezeLocation().getX());
            loc.setY(frozenState.getFreezeLocation().getY());
            loc.setZ(frozenState.getFreezeLocation().getZ());
            player.sendMessage(ChatColor.RED + "\u0412\u044b \u0437\u0430\u043c\u043e\u0440\u043e\u0436\u0435\u043d\u044b.");
            player.teleport(loc);
        }
    }

    public class Commands {
        @Command(aliases={"freeze"}, usage="<target>", desc="Freeze a player", min=1, max=1)
        @CommandPermissions(value={"commandbook.freeze"})
        public void freeze(CommandContext args, CommandSender sender) throws CommandException {
            Player player = PlayerUtil.matchSinglePlayer(sender, args.getString(0));
            if (!FreezeComponent.this.freezePlayer(player)) {
                player.sendMessage(ChatColor.YELLOW + "\u0412\u044b \u0431\u044b\u043b\u0438 \u0437\u0430\u043c\u043e\u0440\u043e\u0436\u0435\u043d\u044b " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW));
                sender.sendMessage(ChatColor.YELLOW + "\u0422\u044b \u0437\u0430\u043c\u043e\u0440\u043e\u0436\u0435\u043d " + PlayerUtil.toColoredName((CommandSender)player, ChatColor.YELLOW));
            } else {
                player.sendMessage(ChatColor.YELLOW + "\u0412\u0430\u0448\u0435 \u043c\u0435\u0441\u0442\u043e\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0437\u0430\u043c\u043e\u0440\u0430\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u0431\u044b\u043b\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430 " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW));
                sender.sendMessage(ChatColor.YELLOW + "\u0412\u044b \u043e\u0431\u043d\u043e\u0432\u0438\u043b\u0438 \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0437\u0430\u043c\u043e\u0440\u0430\u0436\u0438\u0432\u0430\u043d\u0438\u044f " + PlayerUtil.toColoredName((CommandSender)player, ChatColor.YELLOW));
            }
        }

        @Command(aliases={"unfreeze"}, usage="<target>", desc="Unfreeze a player", min=1, max=1)
        @CommandPermissions(value={"commandbook.freeze"})
        public void unfreeze(CommandContext args, CommandSender sender) throws CommandException {
            Player player = PlayerUtil.matchSinglePlayer(sender, args.getString(0));
            if (!FreezeComponent.this.unfreezePlayer(player)) {
                throw new CommandException(PlayerUtil.toName((CommandSender)player) + " \u043d\u0435 \u0431\u044b\u043b \u0437\u0430\u043c\u043e\u0440\u043e\u0436\u0435\u043d");
            }
            player.sendMessage(ChatColor.YELLOW + "\u0412\u044b \u0431\u044b\u043b\u0438 \u0440\u0430\u0437\u043c\u043e\u0440\u043e\u0436\u0435\u043d\u044b \u043f\u043e " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW));
            sender.sendMessage(ChatColor.YELLOW + "\u0423 \u0442\u0435\u0431\u044f \u0440\u0430\u0437\u043c\u043e\u0440\u043e\u0436\u0435\u043d\u044b " + PlayerUtil.toColoredName((CommandSender)player, ChatColor.YELLOW));
        }
    }

    private static class FreezeState
    extends PersistentSession {
        public static final long MAX_AGE = TimeUnit.MINUTES.toMillis(30L);
        private Location freezeLocation;

        protected FreezeState() {
            super(MAX_AGE);
        }

        public boolean isFrozen() {
            return this.freezeLocation != null;
        }

        public Location getFreezeLocation() {
            return this.freezeLocation;
        }

        public void freeze(Location loc) {
            this.freezeLocation = loc == null ? null : loc.clone();
        }

        public Player getOwner() {
            CommandSender sender = super.getOwner();
            return sender instanceof Player ? (Player)sender : null;
        }
    }
}

