/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.CommandBookUtil;
import com.sk89q.commandbook.util.EntityUtil;
import com.sk89q.commandbook.util.ItemUtil;
import com.sk89q.commandbook.util.LocationUtil;
import com.sk89q.commandbook.util.PlayerUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

@ComponentInformation(friendlyName="Fun", desc="Provides some fun commands to toy with users. (/rocket and /pong are two fun ones)")
public class FunComponent
extends BukkitComponent {
    private static final Random random = new Random();

    public void enable() {
        this.registerCommands(Commands.class);
    }

    public LivingEntity spawn(Location loc, EntityType type, String specialType, CommandContext args, CommandSender sender) throws CommandException {
        LivingEntity creature = loc.getWorld().spawnCreature(loc, type);
        if (args.hasFlag('d')) {
            creature.setHealth(1);
        }
        if (args.hasFlag('i')) {
            creature.setFireTicks(500);
        }
        if (args.hasFlag('r')) {
            creature.setVelocity(new Vector(0, 2, 0));
        }
        if (args.hasFlag('b') && creature instanceof Animals) {
            ((Animals)creature).setBaby();
        }
        if (!specialType.equals("")) {
            if (creature instanceof Wolf) {
                if (specialType.matches("angry")) {
                    ((Wolf)creature).setAngry(true);
                    return creature;
                }
                if (specialType.matches("sit(ting)?")) {
                    ((Wolf)creature).setSitting(true);
                    return creature;
                }
                if (specialType.matches("tame(d)?") && sender instanceof Player) {
                    ((Wolf)creature).setOwner((AnimalTamer)((Player)sender));
                    return creature;
                }
            } else {
                if (creature instanceof Creeper && specialType.matches("(power(ed)?|electric|lightning|shock(ed)?)")) {
                    ((Creeper)creature).setPowered(true);
                    return creature;
                }
                if (creature instanceof Sheep) {
                    if (specialType.matches("shear(ed)?")) {
                        ((Sheep)creature).setSheared(true);
                        return creature;
                    }
                    ((Sheep)creature).setColor(ItemUtil.matchDyeColor(specialType));
                    return creature;
                }
                if (creature instanceof Pig && specialType.matches("saddle(d)?")) {
                    ((Pig)creature).setSaddle(true);
                    return creature;
                }
                if (creature instanceof Slime) {
                    ((Slime)creature).setSize(Integer.parseInt(specialType));
                    return creature;
                }
                if (creature instanceof PigZombie) {
                    if (specialType.matches("angry")) {
                        ((PigZombie)creature).setAngry(true);
                        return creature;
                    }
                    ((PigZombie)creature).setAnger(Integer.parseInt(specialType));
                    return creature;
                }
                if (creature instanceof Enderman) {
                    ItemStack item = CommandBook.inst().getItem(specialType);
                    if (item == null) {
                        return creature;
                    }
                    ((Enderman)creature).setCarriedMaterial(item.getData());
                    return creature;
                }
                if (creature instanceof IronGolem && specialType.matches("(friendly|player(-created)?)")) {
                    ((IronGolem)creature).setPlayerCreated(true);
                } else if (creature instanceof Villager) {
                    Villager.Profession profession;
                    try {
                        profession = Villager.Profession.valueOf((String)specialType.toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        throw new CommandException("Unknown profession '" + specialType + "'");
                    }
                    if (profession != null) {
                        ((Villager)creature).setProfession(profession);
                    }
                }
            }
        }
        return creature;
    }

    public class Commands {
        @Command(aliases={"ping"}, usage="", desc="A dummy command", flags="", min=0, max=0)
        public void ping(CommandContext args, CommandSender sender) throws CommandException {
            sender.sendMessage(ChatColor.YELLOW + "\u041f\u043e\u043d\u0433!");
        }

        @Command(aliases={"pong"}, usage="", desc="A dummy command", flags="", min=0, max=0)
        public void pong(CommandContext args, CommandSender sender) throws CommandException {
            sender.sendMessage(ChatColor.YELLOW + "\u044f \u0441\u043b\u044b\u0448\u0443 " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " \u043d\u0440\u0430\u0432\u0438\u0442\u0441\u044f \u043c\u0438\u043b\u043e \u0430\u0437\u0438\u0430\u0442\u0441\u043a\u0438\u0445 \u043c\u0430\u043b\u044c\u0447\u0438\u043a\u043e\u0432.");
        }

        @Command(aliases={"spawnmob"}, usage="<mob>[|rider] [count] [location]", desc="Spawn a mob", flags="dirb", min=1, max=4)
        @CommandPermissions(value={"commandbook.spawnmob"})
        public void spawnMob(CommandContext args, CommandSender sender) throws CommandException {
            String creatureName;
            String[] nameParts;
            Location loc = args.argsLength() >= 3 ? LocationUtil.matchLocation(sender, args.getString(2)) : PlayerUtil.checkPlayer(sender).getLocation();
            String[] creatureInput = args.getString(0).split("\\|");
            boolean hasRider = creatureInput.length == 2;
            String riderName = "";
            String specialType = "";
            String riderSpecialType = "";
            if (creatureInput[0].contains(":")) {
                nameParts = creatureInput[0].split(":", 2);
                creatureName = nameParts[0];
                specialType = nameParts[1].toLowerCase();
            } else {
                creatureName = creatureInput[0];
            }
            if (hasRider) {
                if (creatureInput[1].contains(":")) {
                    nameParts = creatureInput[1].split(":", 2);
                    riderName = nameParts[0];
                    riderSpecialType = nameParts[1].toLowerCase();
                } else {
                    riderName = creatureInput[1];
                }
            }
            int count = Math.max(1, args.getInteger(1, 1));
            EntityType type = EntityUtil.matchCreatureType(sender, creatureName, true);
            EntityType riderType = null;
            if (hasRider) {
                riderType = EntityUtil.matchCreatureType(sender, riderName, true);
                CommandBook.inst().checkPermission(sender, "commandbook.spawnmob." + riderType.getName());
            }
            CommandBook.inst().checkPermission(sender, "commandbook.spawnmob." + type.getName());
            if ((hasRider ? count * 2 : count) > 10) {
                CommandBook.inst().checkPermission(sender, "commandbook.spawnmob.many");
            }
            for (int i = 0; i < count; ++i) {
                LivingEntity ridee = FunComponent.this.spawn(loc, type, specialType, args, sender);
                if (!hasRider) continue;
                LivingEntity rider = FunComponent.this.spawn(loc, riderType, riderSpecialType, args, sender);
                ridee.setPassenger((Entity)rider);
            }
            sender.sendMessage(ChatColor.YELLOW + "" + count + " \u043c\u043e\u0431(\u043e\u0432) \u0437\u0430\u0441\u043f\u0430\u0432\u043d\u0435\u043d\u043e!");
        }

        @Command(aliases={"slap"}, usage="[target]", desc="Slap a player", flags="hdvs", min=0, max=1)
        @CommandPermissions(value={"commandbook.slap"})
        public void slap(CommandContext args, CommandSender sender) throws CommandException {
            Iterable<Player> targets = null;
            boolean included = false;
            int count = 0;
            if (args.argsLength() == 0) {
                targets = PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
            } else if (args.argsLength() == 1) {
                targets = PlayerUtil.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player == sender) continue;
                CommandBook.inst().checkPermission(sender, "commandbook.slap.other");
                break;
            }
            for (Player player : targets) {
                ++count;
                if (args.hasFlag('v')) {
                    player.setVelocity(new Vector(random.nextDouble() * 10.0 - 5.0, random.nextDouble() * 10.0, random.nextDouble() * 10.0 - 5.0));
                } else if (args.hasFlag('h')) {
                    player.setVelocity(new Vector(random.nextDouble() * 5.0 - 2.5, random.nextDouble() * 5.0, random.nextDouble() * 5.0 - 2.5));
                } else {
                    player.setVelocity(new Vector(random.nextDouble() * 2.0 - 1.0, random.nextDouble() * 1.0, random.nextDouble() * 2.0 - 1.0));
                }
                if (args.hasFlag('d')) {
                    player.setHealth(player.getHealth() - 1);
                }
                if (args.hasFlag('s')) {
                    if (player.equals(sender)) {
                        player.sendMessage(ChatColor.YELLOW + "\u041f\u043e\u0449\u0435\u0447\u0438\u043d\u044b!");
                        included = true;
                        continue;
                    }
                    player.sendMessage(ChatColor.YELLOW + "\u0422\u044b \u0443\u0434\u0430\u0440\u0438\u043b \u043f\u043e " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
                    continue;
                }
                if (count < 6) {
                    CommandBook.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " \u0445\u043b\u043e\u043f\u043d\u0443\u043b" + PlayerUtil.toColoredName((CommandSender)player, ChatColor.YELLOW));
                    continue;
                }
                if (count != 6) continue;
                CommandBook.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + "  \u0445\u043b\u043e\u043f\u043d\u0443\u043b \u043c\u043d\u043e\u0433\u043e \u043b\u044e\u0434\u0435\u0439 ... ");
            }
            if (!included && args.hasFlag('s')) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "\u0418\u0433\u0440\u043e\u043a\u0438 \u0448\u043b\u0451\u043f\u043d\u0443\u0442\u044b.");
            }
        }

        @Command(aliases={"rocket"}, usage="[target]", desc="Rocket a player", flags="hs", min=0, max=1)
        @CommandPermissions(value={"commandbook.rocket"})
        public void rocket(CommandContext args, CommandSender sender) throws CommandException {
            Iterable<Player> targets = null;
            boolean included = false;
            int count = 0;
            if (args.argsLength() == 0) {
                targets = PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
            } else if (args.argsLength() == 1) {
                targets = PlayerUtil.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player == sender) continue;
                CommandBook.inst().checkPermission(sender, "commandbook.rocket.other");
                break;
            }
            for (Player player : targets) {
                if (args.hasFlag('h')) {
                    player.setVelocity(new Vector(0, 50, 0));
                } else {
                    player.setVelocity(new Vector(0, 20, 0));
                }
                if (args.hasFlag('s')) {
                    if (player.equals(sender)) {
                        player.sendMessage(ChatColor.YELLOW + "\u0412\u0437\u043b\u0435\u0442!");
                        included = true;
                        continue;
                    }
                    player.sendMessage(ChatColor.YELLOW + "\u0422\u044b \u0432\u0437\u043b\u0435\u0442\u0435\u043b \u043d\u0430 " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
                    continue;
                }
                if (++count < 6) {
                    CommandBook.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " \u0432\u0437\u043b\u0435\u0442\u0435\u043b\u0438 " + PlayerUtil.toColoredName((CommandSender)player, ChatColor.YELLOW));
                    continue;
                }
                if (count != 6) continue;
                CommandBook.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " \u0432\u0437\u043b\u0435\u0442\u0435\u043b\u0438 \u043c\u043d\u043e\u0433\u043e \u043b\u044e\u0434\u0435\u0439 ...");
            }
            if (!included && args.hasFlag('s')) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "\u0418\u0433\u0440\u043e\u043a\u0438 \u0432\u0437\u043b\u0435\u0442\u0435\u043b\u0438.");
            }
        }

        @Command(aliases={"barrage"}, usage="[target]", desc="Send a barrage of arrows", flags="s", min=0, max=1)
        @CommandPermissions(value={"commandbook.barrage"})
        public void barrage(CommandContext args, CommandSender sender) throws CommandException {
            Iterable<Player> targets = null;
            boolean included = false;
            int count = 0;
            if (args.argsLength() == 0) {
                targets = PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
            } else if (args.argsLength() == 1) {
                targets = PlayerUtil.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.barrage.other");
                    break;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.barrage");
            }
            for (Player player : targets) {
                double diff = 0.2617993877991494;
                for (double a = 0.0; a < Math.PI * 2; a += diff) {
                    Vector vel = new Vector(Math.cos(a), 0.0, Math.sin(a));
                    CommandBookUtil.sendArrowFromPlayer(player, vel, 2.0f);
                }
                if (args.hasFlag('s')) {
                    if (player.equals(sender)) {
                        player.sendMessage(ChatColor.YELLOW + "Barrage \u0430\u0442\u0430\u043a\u0430!");
                        included = true;
                        continue;
                    }
                    player.sendMessage(ChatColor.YELLOW + "BARRAGE \u0430\u0442\u0430\u043a\u0430 \u043d\u0430 " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
                    continue;
                }
                if (count < 6) {
                    CommandBook.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u0433\u0440\u0430\u0436\u0434\u0435\u043d\u0438\u044f \u043d\u0430" + PlayerUtil.toColoredName((CommandSender)player, ChatColor.YELLOW));
                    continue;
                }
                if (count != 6) continue;
                CommandBook.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438 \u0435\u0433\u043e \u043d\u0430 \u0431\u043e\u043b\u044c\u0448\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043b\u044e\u0434\u0435\u0439 ...");
            }
            if (!included && args.hasFlag('s')) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "Barrage \u0430\u0442\u0430\u043a\u0430 \u043f\u043e\u0441\u043b\u0430\u043d\u0430.");
            }
        }

        @Command(aliases={"firebarrage"}, usage="[target]", desc="Send a attack of fireballs", flags="s", min=0, max=1)
        @CommandPermissions(value={"commandbook.firebarrage"})
        public void barragefire(CommandContext args, CommandSender sender) throws CommandException {
            Iterable<Player> targets = null;
            boolean included = false;
            int count = 0;
            if (args.argsLength() == 0) {
                targets = PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
            } else if (args.argsLength() == 1) {
                targets = PlayerUtil.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.firebarrage.other");
                    break;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.firebarrage");
            }
            for (Player player : targets) {
                CommandBookUtil.sendFireballsFromPlayer(player, 8);
                if (args.hasFlag('s')) {
                    if (player.equals(sender)) {
                        player.sendMessage(ChatColor.YELLOW + "\u0424\u0430\u0439\u0440\u0411\u043e\u043b\u043b \u0430\u0442\u0430\u043a\u0430!");
                        included = true;
                        continue;
                    }
                    player.sendMessage(ChatColor.YELLOW + "\u0424\u0430\u0439\u0440\u0411\u043e\u043b\u043b \u0430\u0442\u0430\u043a\u0430 \u043d\u0430 " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
                    continue;
                }
                if (count < 6) {
                    CommandBook.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c Fireball \u043d\u0430\u043f\u0430\u0434\u0435\u043d\u0438\u0435 \u043d\u0430" + PlayerUtil.toColoredName((CommandSender)player, ChatColor.YELLOW));
                    continue;
                }
                if (count != 6) continue;
                CommandBook.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438 \u0435\u0433\u043e \u043d\u0430 \u0431\u043e\u043b\u044c\u0448\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043b\u044e\u0434\u0435\u0439 ...");
            }
            if (!included && args.hasFlag('s')) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "Fireball \u0430\u0442\u0430\u043a\u0443 \u043f\u043e\u0441\u043b\u0430\u043d\u0430.");
            }
        }

        @Command(aliases={"cannon"}, usage="[target]", desc="Send a ball of fire to a face", flags="s", min=0, max=1)
        @CommandPermissions(value={"commandbook.cannon"})
        public void cannon(CommandContext args, CommandSender sender) throws CommandException {
            Iterable<Player> targets = null;
            boolean included = false;
            int count = 0;
            if (args.argsLength() == 0) {
                targets = PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
            } else if (args.argsLength() == 1) {
                targets = PlayerUtil.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.cannon.other");
                    break;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.cannon");
            }
            for (Player player : targets) {
                double diff = 0.2617993877991494;
                for (double a = 0.0; a < Math.PI * 2; a += diff) {
                    CommandBookUtil.sendCannonToPlayer(player);
                }
                if (args.hasFlag('s')) {
                    if (player.equals(sender)) {
                        player.sendMessage(ChatColor.YELLOW + "\u0424\u0430\u0439\u0440\u0411\u043e\u043b\u043b \u0430\u0442\u0430\u043a\u0430!");
                        included = true;
                        continue;
                    }
                    player.sendMessage(ChatColor.YELLOW + "\u0424\u0430\u0439\u0440\u0411\u043e\u043b\u043b \u0430\u0442\u0430\u043a\u0430 \u043d\u0430 " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
                    continue;
                }
                if (count < 6) {
                    CommandBook.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c Fireball \u043d\u0430\u043f\u0430\u0434\u0435\u043d\u0438\u0435 \u043d\u0430" + PlayerUtil.toColoredName((CommandSender)player, ChatColor.YELLOW));
                    continue;
                }
                if (count != 6) continue;
                CommandBook.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438 \u0435\u0433\u043e \u0431\u043e\u043b\u044c\u0448\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043b\u044e\u0434\u0435\u0439 ...");
            }
            if (!included && args.hasFlag('s')) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "Fireball \u0430\u0442\u0430\u043a\u0443 \u043f\u043e\u0441\u043b\u0430\u043d\u0430.");
            }
        }
    }
}

