/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.InfoComponent;
import com.sk89q.commandbook.util.PlayerUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import com.zachsthings.libcomponents.config.ConfigurationBase;
import com.zachsthings.libcomponents.config.Setting;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

@ComponentInformation(friendlyName="God", desc="God mode support")
public class GodComponent
extends BukkitComponent
implements Listener {
    public static final String METADATA_KEY = "\u0431\u043e\u0433";
    private LocalConfiguration config;

    public void enable() {
        this.config = this.configure(new LocalConfiguration());
        this.registerCommands(Commands.class);
        for (Player player : CommandBook.server().getOnlinePlayers()) {
            this.checkAutoEnable(player);
        }
        CommandBook.registerEvents(this);
    }

    public void reload() {
        super.reload();
        this.config = this.configure(this.config);
        for (Player player : CommandBook.server().getOnlinePlayers()) {
            this.checkAutoEnable(player);
        }
    }

    public void enableGodMode(Player player) {
        if (!this.hasGodMode(player)) {
            player.setMetadata(METADATA_KEY, (MetadataValue)new FixedMetadataValue((Plugin)CommandBook.inst(), (Object)true));
        }
    }

    public void disableGodMode(Player player) {
        player.removeMetadata(METADATA_KEY, (Plugin)CommandBook.inst());
    }

    public boolean hasGodMode(Player player) {
        List values = player.getMetadata(METADATA_KEY);
        switch (values.size()) {
            case 0: {
                return false;
            }
            case 1: {
                return ((MetadataValue)values.get(0)).asBoolean();
            }
        }
        for (MetadataValue val : values) {
            if (!val.asBoolean()) continue;
            return true;
        }
        return false;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.checkAutoEnable(event.getPlayer());
    }

    private boolean checkAutoEnable(Player player) {
        if (this.config.autoEnable && (CommandBook.inst().getPermissionsResolver().inGroup((OfflinePlayer)player, "cb-invincible") || CommandBook.inst().hasPermission((CommandSender)player, "commandbook.god.auto-invincible"))) {
            this.enableGodMode(player);
            return true;
        }
        return false;
    }

    @EventHandler
    public void onCombust(EntityCombustEvent event) {
        Player player;
        if (event.isCancelled()) {
            return;
        }
        if (event.getEntity() instanceof Player && this.hasGodMode(player = (Player)event.getEntity())) {
            event.setCancelled(true);
            player.setFireTicks(0);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        Player player;
        if (event.isCancelled()) {
            return;
        }
        if (event.getEntity() instanceof Player && this.hasGodMode(player = (Player)event.getEntity())) {
            event.setCancelled(true);
            player.setFireTicks(0);
        }
    }

    @EventHandler
    public void playerChangedWorld(PlayerChangedWorldEvent event) {
        if (!CommandBook.inst().hasPermission((CommandSender)event.getPlayer(), "commandbook.god")) {
            this.disableGodMode(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void foodLevelChange(FoodLevelChangeEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (event.getFoodLevel() < player.getFoodLevel() && this.hasGodMode(player)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void playerWhois(InfoComponent.PlayerWhoisEvent event) {
        if (event.getPlayer() instanceof Player && CommandBook.inst().hasPermission(event.getSource(), "commandbook.god.check")) {
            event.addWhoisInformation(null, "\u0418\u0433\u0440\u043e\u043a " + (this.hasGodMode((Player)event.getPlayer()) ? "\u0438\u043c\u0435\u0435\u0442" : "\u043d\u0435 \u0438\u043c\u0435\u0435\u0442") + " \u0440\u0435\u0436\u0438\u043c \u0431\u043e\u0433\u0430");
        }
    }

    public class Commands {
        @Command(aliases={"god"}, usage="[player]", desc="Enable godmode on a player", flags="s", max=1)
        public void god(CommandContext args, CommandSender sender) throws CommandException {
            Iterable<Player> targets = null;
            boolean included = false;
            if (args.argsLength() == 0) {
                targets = PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
            } else if (args.argsLength() == 1) {
                targets = PlayerUtil.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player == sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.god");
                    continue;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.god.other");
                break;
            }
            for (Player player : targets) {
                if (GodComponent.this.hasGodMode(player)) {
                    if (player == sender) {
                        player.sendMessage(ChatColor.RED + "\u0423 \u0432\u0430\u0441 \u0443\u0436\u0435 \u0435\u0441\u0442\u044c \u0440\u0435\u0436\u0438\u043c \u0431\u043e\u0433\u0430!");
                        included = true;
                        continue;
                    }
                    sender.sendMessage(ChatColor.RED + player.getName() + " \u0443\u0436\u0435 \u0438\u043c\u0435\u0435\u0442 \u0440\u0435\u0436\u0438\u043c \u0431\u043e\u0433\u0430!");
                    continue;
                }
                GodComponent.this.enableGodMode(player);
                player.setFireTicks(0);
                if (player.equals(sender)) {
                    player.sendMessage(ChatColor.YELLOW + "\u0411\u043e\u0433 \u0440\u0435\u0436\u0438\u043c \u0432\u043a\u043b\u044e\u0447\u0435\u043d! \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 /ungod , \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c.");
                    included = true;
                    continue;
                }
                if (args.hasFlag('s')) continue;
                player.sendMessage(ChatColor.YELLOW + "\u0420\u0435\u0436\u0438\u043c \u0431\u043e\u0433\u0430 \u0432\u043a\u043b\u044e\u0447\u0435\u043d " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
            }
            if (!included) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "\u0418\u0433\u0440\u043e\u043a\u0438 \u0438\u043c\u0435\u044e\u0442 \u0440\u0435\u0436\u0438\u043c \u0431\u043e\u0433\u0430.");
            }
        }

        @Command(aliases={"ungod"}, usage="[player]", desc="Disable godmode on a player", flags="s", max=1)
        public void ungod(CommandContext args, CommandSender sender) throws CommandException {
            Iterable<Player> targets = null;
            boolean included = false;
            if (args.argsLength() == 0) {
                targets = PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
            } else if (args.argsLength() == 1) {
                targets = PlayerUtil.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player == sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.god");
                    continue;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.god.other");
                break;
            }
            for (Player player : targets) {
                if (!GodComponent.this.hasGodMode(player)) {
                    if (player == sender) {
                        player.sendMessage(ChatColor.RED + "\u0412\u044b \u043d\u0435 \u0438\u043c\u0435\u0435\u0442\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u043d\u044b\u0439 \u0431\u043e\u0433 \u0440\u0435\u0436\u0438\u043c!");
                        included = true;
                        continue;
                    }
                    sender.sendMessage(ChatColor.RED + player.getName() + " \u043d\u0435 \u0431\u044b\u043b\u043e \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u043d\u043e\u0433\u043e \u0440\u0435\u0436\u0438\u043c\u0430 \u0431\u043e\u0433\u0430!");
                    continue;
                }
                GodComponent.this.disableGodMode(player);
                if (player.equals(sender)) {
                    player.sendMessage(ChatColor.YELLOW + "\u0411\u043e\u0433 \u0440\u0435\u0436\u0438\u043c \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d!");
                    included = true;
                    continue;
                }
                player.sendMessage(ChatColor.YELLOW + "\u0420\u0435\u0436\u0438\u043c \u0431\u043e\u0433\u0430 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d \u043e\u0442 " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
            }
            if (!included) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "\u0418\u0433\u0440\u043e\u043a\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u0432 \u0431\u043e\u0433 \u0440\u0435\u0436\u0438\u043c\u0435.");
            }
        }
    }

    private static class LocalConfiguration
    extends ConfigurationBase {
        @Setting(value="auto-enable")
        public boolean autoEnable = false;

        private LocalConfiguration() {
        }
    }
}

