/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook;

import com.sk89q.bukkit.util.DynamicPluginCommand;
import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.CommandBookUtil;
import com.sk89q.commandbook.commands.PaginatedResult;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.util.ReflectionUtil;
import com.sk89q.util.yaml.YAMLFormat;
import com.sk89q.util.yaml.YAMLProcessor;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import com.zachsthings.libcomponents.config.ConfigurationBase;
import com.zachsthings.libcomponents.config.Setting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.defaults.VanillaCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentInformation(friendlyName="Help", desc="Provides help on various command actions")
public class HelpComponent
extends BukkitComponent {
    private YAMLProcessor \u043f\u043e\u043c\u043e\u0449\u044c;
    private final Map<String, String[]> messages = new HashMap<String, String[]>();
    private LocalConfiguration config;
    private static final String demoHelpMessage = "\u042d\u0442\u043e \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u043f\u0440\u0430\u0432\u043a\u0438 \u0434\u043b\u044f \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u0432\r\n`r/help -\u0441 <commandname>`w \u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442 \u043f\u043e\u043c\u043e\u0449\u044c \u0434\u043b\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b\r\n`r/help <topic>`w \u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442 \u043f\u043e\u043c\u043e\u0449\u044c \u0432 \u0442\u0435\u043c\u0443 \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430, \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0433\u043e \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u043e\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0430.";

    @Override
    public void enable() {
        this.config = this.configure(new LocalConfiguration());
        File helpFile = new File(CommandBook.inst().getDataFolder(), this.config.helpFile);
        if (!helpFile.getParentFile().exists() || !helpFile.getParentFile().isDirectory()) {
            helpFile.getParentFile().mkdirs();
        }
        if (!helpFile.exists() || !helpFile.isFile()) {
            try {
                helpFile.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.\u043f\u043e\u043c\u043e\u0449\u044c = new YAMLProcessor(helpFile, true, YAMLFormat.EXTENDED);
        this.reloadMessages();
        this.registerCommands(HelpCommands.class);
    }

    @Override
    public void reload() {
        super.reload();
        this.reloadMessages();
        this.configure(this.config);
    }

    private boolean reloadMessages() {
        try {
            this.\u043f\u043e\u043c\u043e\u0449\u044c.load();
        }
        catch (IOException e) {
            return false;
        }
        ArrayList<String> keys = this.\u043f\u043e\u043c\u043e\u0449\u044c.getKeys("topics");
        if (keys == null) {
            this.\u043f\u043e\u043c\u043e\u0449\u044c.setProperty("topics.help", (Object)demoHelpMessage);
            keys = new ArrayList<String>();
            keys.add("\u043f\u043e\u043c\u043e\u0449\u044c");
            this.\u043f\u043e\u043c\u043e\u0449\u044c.save();
        }
        for (String key : keys) {
            String information = this.\u043f\u043e\u043c\u043e\u0449\u044c.getString("\u0442\u0435\u043c\u044b." + key);
            if (information == null || information.trim().length() == 0) continue;
            information = CommandBookUtil.replaceColorMacros(information);
            String[] split = information.split("\\n");
            for (int i = 0; i < split.length; ++i) {
                split[i] = split[i].replaceAll("[\\r\\n]", "");
            }
            this.messages.put(key.toLowerCase(), split);
        }
        return true;
    }

    public void printTopics(CommandSender sender, String prefix) {
        StringBuilder sb = new StringBuilder(ChatColor.YELLOW.toString());
        if (prefix != null && !prefix.isEmpty()) {
            sb.append(prefix).append(" ");
        }
        sb.append("Available options are: ");
        boolean first = true;
        int count = 0;
        for (String key : this.messages.keySet()) {
            if (!CommandBook.inst().hasPermission(sender, "commandbook.help.topic." + key)) continue;
            if (!first) {
                sb.append(ChatColor.YELLOW).append(", ");
            }
            sb.append(ChatColor.LIGHT_PURPLE).append(key);
            first = false;
            ++count;
        }
        if (count <= 0) {
            sender.sendMessage(ChatColor.YELLOW + "\u041d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u0432\u0430\u0440\u0438\u0430\u043d\u0442\u043e\u0432 \u043f\u043e\u043c\u043e\u0449\u0438!");
        } else {
            sender.sendMessage(sb.toString());
        }
    }

    public Command getCommand(String name) {
        CommandMap commandMap = (CommandMap)ReflectionUtil.getField((Object)CommandBook.server().getPluginManager(), (String)"commandMap");
        if (commandMap == null) {
            return null;
        }
        return commandMap.getCommand(name);
    }

    public Collection<Command> getServerCommands() {
        CommandMap commandMap = (CommandMap)ReflectionUtil.getField((Object)CommandBook.server().getPluginManager(), (String)"commandMap");
        if (commandMap == null) {
            return Collections.emptySet();
        }
        HashSet<Command> cmds = new HashSet<Command>(((SimpleCommandMap)commandMap).getFallbackCommands());
        cmds.addAll(((SimpleCommandMap)commandMap).getCommands());
        return cmds;
    }

    public void printCommandHelp(CommandSender sender, Command cmd) {
        sender.sendMessage(ChatColor.YELLOW + "\u041a\u043e\u043c\u0430\u043d\u0434\u044b: " + cmd.getName());
        String aliases = cmd.getAliases().toString().replaceAll("\\[(.*)\\]", "$1");
        if (aliases.length() > 0) {
            sender.sendMessage(ChatColor.YELLOW + "Aliases: " + aliases);
        }
        sender.sendMessage(ChatColor.YELLOW + "Description: " + cmd.getDescription());
        sender.sendMessage(ChatColor.YELLOW + "Usage: " + cmd.getUsage());
        if (cmd instanceof PluginCommand) {
            sender.sendMessage(ChatColor.YELLOW + "Plugin: " + ((PluginCommand)cmd).getPlugin().getDescription().getName());
        } else if (cmd instanceof DynamicPluginCommand) {
            sender.sendMessage(ChatColor.YELLOW + "Owner: " + ((DynamicPluginCommand)cmd).getOwner().getClass().getSimpleName());
        } else if (cmd instanceof VanillaCommand) {
            sender.sendMessage(ChatColor.YELLOW + "Vanilla command");
        }
    }

    public class HelpCommands {
        @com.sk89q.minecraft.util.commands.Command(aliases={"help"}, usage="[-p page] [topic]", desc="Provides help for the server!", flags="cp:", min=0, max=1)
        @CommandPermissions(value={"commandbook.help", "commandbook.help.command", "commandbook.help.topic"})
        public void help(CommandContext args, CommandSender sender) throws CommandException {
            if (args.hasFlag('c')) {
                if (!((HelpComponent)HelpComponent.this).config.commandHelp) {
                    throw new CommandException("\u041f\u043e\u043c\u043e\u0449\u044c \u0434\u043b\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430!");
                }
                if (args.argsLength() == 0) {
                    Collection<Command> serverCommands = HelpComponent.this.getServerCommands();
                    Iterator<Command> i = serverCommands.iterator();
                    while (i.hasNext()) {
                        String permission = i.next().getPermission();
                        if (permission == null || permission.length() == 0 || CommandBook.inst().hasPermission(sender, permission)) continue;
                        i.remove();
                    }
                    new PaginatedResult<Command>("Usage - Description"){

                        @Override
                        public String format(Command entry) {
                            return entry.getUsage() + " - " + entry.getDescription();
                        }
                    }.display(sender, serverCommands, args.getFlagInteger('p', 1));
                } else {
                    Command cmd = HelpComponent.this.getCommand(args.getString(0));
                    if (cmd == null) {
                        throw new CommandException("Unknown command '" + args.getString(0) + "'; no help available");
                    }
                    CommandBook.inst().checkPermission(sender, "commandbook.help.command." + cmd.getName());
                    HelpComponent.this.printCommandHelp(sender, cmd);
                }
            } else if (args.argsLength() == 0) {
                HelpComponent.this.printTopics(sender, "\u041d\u0438\u043a\u0430\u043a\u043e\u0439 \u043f\u043e\u043c\u043e\u0449\u0438 \u043e\u043f\u0446\u0438\u0438.");
            } else if (!HelpComponent.this.messages.containsKey(args.getString(0).toLowerCase())) {
                HelpComponent.this.printTopics(sender, "Unknown topic specified.");
            } else {
                String chosen = args.getString(0);
                CommandBook.inst().checkPermission(sender, "commandbook.help.topic." + chosen);
                String[] lines = (String[])HelpComponent.this.messages.get(chosen.toLowerCase());
                sender.sendMessage(ChatColor.YELLOW + "Help about " + chosen + ":");
                for (String line : lines) {
                    sender.sendMessage(ChatColor.AQUA + line.replaceAll(ChatColor.WHITE.toString(), ChatColor.AQUA.toString()));
                }
            }
        }
    }

    private static class LocalConfiguration
    extends ConfigurationBase {
        @Setting(value="help-file")
        public String helpFile = "help.yml";
        @Setting(value="command-help")
        public boolean commandHelp = true;

        private LocalConfiguration() {
        }
    }
}

