/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.CommandBookUtil;
import com.sk89q.commandbook.util.PlayerUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldedit.blocks.ItemType;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import com.zachsthings.libcomponents.config.ConfigurationBase;
import com.zachsthings.libcomponents.config.Setting;
import java.util.Collections;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

@ComponentInformation(friendlyName="Inventory", desc="Inventory-related commands, such as /give and /clear, are handled in this component.")
public class InventoryComponent
extends BukkitComponent {
    protected LocalConfiguration config;

    public void enable() {
        this.config = this.configure(new LocalConfiguration());
        this.registerCommands(Commands.class);
    }

    public void reload() {
        super.reload();
        this.configure(this.config);
    }

    public void checkAllowedItem(CommandSender sender, int id, int damage) throws CommandException {
        boolean hasPermissions;
        if (Material.getMaterial((int)id) == null || id == 0) {
            throw new CommandException("\u041d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0442.");
        }
        if (CommandBook.inst().hasPermission(sender, "commandbook.override.any-item")) {
            return;
        }
        boolean bl = hasPermissions = CommandBook.inst().hasPermission(sender, "commandbook.items." + id) || CommandBook.inst().hasPermission(sender, "commandbook.items." + id + "." + damage);
        if (hasPermissions) {
            return;
        }
        if (this.config.useItemPermissionsOnly) {
            throw new CommandException("\u042d\u0442\u043e\u0442 \u043f\u0443\u043d\u043a\u0442 \u043d\u0435 \u0434\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u0442\u0441\u044f.");
        }
        if (this.config.allowedItems.size() > 0 && !this.config.allowedItems.contains(id)) {
            throw new CommandException("\u042d\u0442\u043e\u0442 \u043f\u0443\u043d\u043a\u0442 \u043d\u0435 \u0434\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u0442\u0441\u044f.");
        }
        if (this.config.disallowedItems.contains(id)) {
            throw new CommandException("\u042d\u0442\u043e\u0442 \u043f\u0443\u043d\u043a\u0442 \u043d\u0435 \u0434\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u0442\u0441\u044f.");
        }
    }

    private ItemStack matchItem(String name) throws CommandException {
        return CommandBook.inst().getCommandItem(name);
    }

    public class Commands {
        @Command(aliases={"item", "i"}, usage="[target] <item[:data][|enchantment:level]> [amount]", desc="Give an item", flags="do", min=1, max=3)
        @CommandPermissions(value={"commandbook.give"})
        public void item(CommandContext args, CommandSender sender) throws CommandException {
            ItemStack item = null;
            int amt = InventoryComponent.this.config.defaultItemStackSize;
            Iterable<Player> targets = null;
            if (args.argsLength() == 1) {
                item = InventoryComponent.this.matchItem(args.getString(0));
                targets = PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
            } else if (args.argsLength() == 2) {
                item = InventoryComponent.this.matchItem(args.getString(0));
                amt = args.getInteger(1);
                targets = PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
            } else if (args.argsLength() == 3) {
                item = InventoryComponent.this.matchItem(args.getString(1));
                amt = args.getInteger(2);
                targets = PlayerUtil.matchPlayers(sender, args.getString(0));
                for (Player player : targets) {
                    if (player == sender) continue;
                    CommandBook.inst().checkPermission(sender, "commandbook.give.other");
                }
            }
            if (item == null) {
                throw new CommandException("\u0427\u0442\u043e-\u0442\u043e \u043f\u043e\u0448\u043b\u043e \u043d\u0435 \u0442\u0430\u043a, \u0440\u0430\u0437\u0431\u043e\u0440 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438!");
            }
            CommandBookUtil.giveItem(sender, item, amt, targets, InventoryComponent.this, args.hasFlag('d'), args.hasFlag('o'));
        }

        @Command(aliases={"give"}, usage="[-d] <target> <item[:data]> [amount]", desc="Give an item", flags="do", min=2, max=3)
        @CommandPermissions(value={"commandbook.give", "commandbook.give.other"})
        public void give(CommandContext args, CommandSender sender) throws CommandException {
            ItemStack item = null;
            int amt = InventoryComponent.this.config.defaultItemStackSize;
            Iterable<Player> targets = null;
            if (args.argsLength() == 2) {
                targets = PlayerUtil.matchPlayers(sender, args.getString(0));
                item = InventoryComponent.this.matchItem(args.getString(1));
            } else if (args.argsLength() == 3) {
                targets = PlayerUtil.matchPlayers(sender, args.getString(0));
                item = InventoryComponent.this.matchItem(args.getString(1));
                amt = args.getInteger(2);
            }
            for (Player target : targets) {
                if (target != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.give.other");
                    continue;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.give");
            }
            if (item == null) {
                throw new CommandException("\u0427\u0442\u043e-\u0442\u043e \u043f\u043e\u0448\u043b\u043e \u043d\u0435 \u0442\u0430\u043a, \u0440\u0430\u0437\u0431\u043e\u0440 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438!");
            }
            CommandBookUtil.giveItem(sender, item, amt, targets, InventoryComponent.this, args.hasFlag('d'), args.hasFlag('o'));
        }

        @Command(aliases={"clear"}, usage="[target]", desc="Clear your inventory", flags="as", min=0, max=1)
        @CommandPermissions(value={"commandbook.clear"})
        public void clear(CommandContext args, CommandSender sender) throws CommandException {
            boolean clearAll = args.hasFlag('a');
            boolean clearSingle = args.hasFlag('s');
            boolean included = false;
            Iterable<Player> targets = args.argsLength() == 0 ? PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender)) : PlayerUtil.matchPlayers(sender, args.getString(0));
            for (Player player : targets) {
                if (sender == player) continue;
                CommandBook.inst().checkPermission(sender, "commandbook.clear.other");
                break;
            }
            for (Player player : targets) {
                PlayerInventory inventory = player.getInventory();
                if (clearSingle) {
                    player.setItemInHand(null);
                } else {
                    int i;
                    int n = i = clearAll ? 0 : 9;
                    while (i < 36) {
                        inventory.setItem(i, null);
                        ++i;
                    }
                    if (clearAll) {
                        for (i = 36; i <= 39; ++i) {
                            inventory.setItem(i, null);
                        }
                    }
                }
                if (player.equals(sender)) {
                    if (clearAll) {
                        player.sendMessage(ChatColor.YELLOW + "\u0412\u0430\u0448 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c \u0431\u044b\u043b \u043e\u0447\u0438\u0449\u0435\u043d.");
                    } else {
                        player.sendMessage(ChatColor.YELLOW + "\u0412\u0430\u0448 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c \u0431\u044b\u043b \u043e\u0447\u0438\u0449\u0435\u043d. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 -a , \u0447\u0442\u043e\u0431\u044b \u043e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0432\u0441\u0435.");
                    }
                    included = true;
                    continue;
                }
                player.sendMessage(ChatColor.YELLOW + "\u0412\u0430\u0448 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c \u0431\u044b\u043b \u043e\u0447\u0438\u0449\u0435\u043d " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW));
            }
            if (!included) {
                sender.sendMessage(ChatColor.YELLOW + "\u0417\u0430\u043f\u0430\u0441\u044b \u043e\u0447\u0438\u0449\u0430\u044e\u0442\u0441\u044f.");
            }
        }

        @Command(aliases={"more"}, usage="[player]", desc="Gets more of an item", flags="aio", min=0, max=1)
        @CommandPermissions(value={"commandbook.more"})
        public void more(CommandContext args, CommandSender sender) throws CommandException {
            boolean moreAll = args.hasFlag('a');
            boolean infinite = args.hasFlag('i');
            boolean overrideStackSize = args.hasFlag('o');
            if (infinite) {
                CommandBook.inst().checkPermission(sender, "commandbook.more.infinite");
            } else if (overrideStackSize) {
                CommandBook.inst().checkPermission(sender, "commandbook.override.maxstacksize");
            }
            boolean included = false;
            Iterable<Player> targets = args.argsLength() == 0 ? PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender)) : PlayerUtil.matchPlayers(sender, args.getString(0));
            for (Player player : targets) {
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.more.other");
                    continue;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.more");
            }
            for (Player player : targets) {
                PlayerInventory inventory = player.getInventory();
                if (moreAll) {
                    for (int i = 0; i < 39; ++i) {
                        CommandBookUtil.expandStack(inventory.getItem(i), infinite, overrideStackSize);
                    }
                } else {
                    CommandBookUtil.expandStack(player.getItemInHand(), infinite, overrideStackSize);
                }
                if (player.equals(sender)) {
                    player.sendMessage(ChatColor.YELLOW + "\u0412\u0430\u0448 \u0442\u043e\u0432\u0430\u0440 \u0431\u044b\u043b \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d \u0432 \u0440\u0430\u0437\u043c\u0435\u0440 \u0441\u0442\u0435\u043a\u0430.");
                    included = true;
                    continue;
                }
                player.sendMessage(ChatColor.YELLOW + "\u0412\u0430\u0448 \u0442\u043e\u0432\u0430\u0440 \u0431\u044b\u043b \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d \u0432 \u0441\u0442\u0435\u043a \u043f\u043e" + PlayerUtil.toColoredName(sender, ChatColor.YELLOW));
            }
            if (!included) {
                sender.sendMessage(ChatColor.YELLOW + "\u0421\u0442\u0435\u043a \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u0443\u0432\u0435\u043b\u0438\u0447\u0438\u043b\u0438\u0441\u044c.");
            }
        }

        @Command(aliases={"take"}, usage="<target> <item[:data]> [amount]", desc="Take an item", flags="", min=2, max=3)
        @CommandPermissions(value={"commandbook.take"})
        public void take(CommandContext args, CommandSender sender) throws CommandException {
            ItemStack item = null;
            int amt = InventoryComponent.this.config.defaultItemStackSize;
            Player target = null;
            if (args.argsLength() == 2) {
                target = PlayerUtil.matchSinglePlayer(sender, args.getString(0));
                item = InventoryComponent.this.matchItem(args.getString(1));
            } else if (args.argsLength() == 3) {
                target = PlayerUtil.matchSinglePlayer(sender, args.getString(0));
                item = InventoryComponent.this.matchItem(args.getString(1));
                amt = args.getInteger(2);
            }
            if (target != sender) {
                CommandBook.inst().checkPermission(sender, "commandbook.take.other");
            } else {
                CommandBook.inst().checkPermission(sender, "commandbook.take");
            }
            if (item == null) {
                throw new CommandException("\u0427\u0442\u043e-\u0442\u043e \u043f\u043e\u0448\u043b\u043e \u043d\u0435 \u0442\u0430\u043a, \u0440\u0430\u0437\u0431\u043e\u0440 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438!");
            }
            CommandBookUtil.takeItem(sender, item, amt, target);
        }

        @Command(aliases={"stack"}, usage="", desc="Stack items", max=0)
        @CommandPermissions(value={"commandbook.stack"})
        public void stack(CommandContext args, CommandSender sender) throws CommandException {
            Player player = PlayerUtil.checkPlayer(sender);
            boolean ignoreMax = CommandBook.inst().hasPermission((CommandSender)player, "commandbook.stack.illegitimate");
            boolean ignoreDamaged = CommandBook.inst().hasPermission((CommandSender)player, "commandbook.stack.damaged");
            ItemStack[] items = player.getInventory().getContents();
            int len = items.length;
            int affected = 0;
            block0: for (int i = 0; i < len; ++i) {
                int max;
                ItemStack item = items[i];
                if (item == null || item.getAmount() <= 0 || !ignoreMax && item.getMaxStackSize() == 1) continue;
                int n = max = ignoreMax ? 64 : item.getMaxStackSize();
                if (item.getAmount() >= max) continue;
                int needed = max - item.getAmount();
                for (int j = i + 1; j < len; ++j) {
                    ItemStack item2 = items[j];
                    if (item2 == null || item2.getAmount() <= 0 || !ignoreMax && item.getMaxStackSize() == 1 || item2.getTypeId() != item.getTypeId() || (ItemType.usesDamageValue((int)item.getTypeId()) || !ignoreDamaged) && item.getDurability() != item2.getDurability() || !((Object)item.getEnchantments()).equals(item2.getEnchantments())) continue;
                    if (item2.getAmount() > needed) {
                        item.setAmount(64);
                        item2.setAmount(item2.getAmount() - needed);
                        continue block0;
                    }
                    items[j] = null;
                    item.setAmount(item.getAmount() + item2.getAmount());
                    needed = 64 - item.getAmount();
                    ++affected;
                }
            }
            if (affected > 0) {
                player.getInventory().setContents(items);
            }
            player.sendMessage(ChatColor.YELLOW + "\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u0443\u043f\u043b\u043e\u0442\u043d\u0435\u043d\u0438\u044f \u0432 \u0441\u0442\u043e\u043f\u043a\u0438!");
        }
    }

    private static class LocalConfiguration
    extends ConfigurationBase {
        @Setting(value="item-permissions-only")
        public boolean useItemPermissionsOnly;
        @Setting(value="allowed-items")
        public Set<Integer> allowedItems = Collections.emptySet();
        @Setting(value="disllowed-items")
        public Set<Integer> disallowedItems = Collections.emptySet();
        @Setting(value="default-item-stack-size")
        public int defaultItemStackSize = 1;

        private LocalConfiguration() {
        }
    }
}

