/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook;

import com.sk89q.commandbook.CommandBook;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import java.util.regex.Pattern;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;

@ComponentInformation(friendlyName="Name Verification", desc="This component verifies that player names are valid when they join.")
public class NameVerificationComponent
extends BukkitComponent
implements Listener {
    protected static final Pattern namePattern = Pattern.compile("^[a-zA-Z0-9_]{1,16}$");

    public void enable() {
        CommandBook.registerEvents(this);
    }

    @EventHandler
    public void onLogin(PlayerLoginEvent event) {
        if (!namePattern.matcher(event.getPlayer().getName()).matches()) {
            CommandBook.logger().info("\u0418\u043c\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438: " + event.getPlayer().getName() + " \u043a\u0438\u043a\u043d\u0443\u0442 " + "\u0437\u0430 \u0442\u043e, \u0447\u0442\u043e \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0435 \u0438\u043c\u044f (\u0434\u043b\u044f \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f, \u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0443 \u0438\u043c\u0435\u043d\u0438 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430 \u0432 CommandBook)");
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u0438\u0433\u0440\u043e\u043a\u0430 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e!");
        }
    }
}

