/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.util.PlayerUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ComponentInformation(friendlyName="Player Commands", desc="Various player-related commands.")
public class PlayerComponent
extends BukkitComponent {
    public void enable() {
        this.registerCommands(Commands.class);
    }

    public class Commands {
        @Command(aliases={"gamemode", "gm"}, usage="[player] [gamemode]", desc="Change a player's gamemode", flags="c", min=0, max=2)
        @CommandPermissions(value={"commandbook.gamemode"})
        public void gamemode(CommandContext args, CommandSender sender) throws CommandException {
            String message;
            Player player;
            GameMode mode = null;
            boolean change = false;
            if (args.argsLength() == 0) {
                CommandBook.inst().checkPermission(sender, "commandbook.gamemode.check");
                player = PlayerUtil.checkPlayer(sender);
                mode = player.getGameMode();
            } else if (args.hasFlag('c')) {
                player = PlayerUtil.matchSinglePlayer(sender, args.getString(0));
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.gamemode.check.other");
                } else {
                    CommandBook.inst().checkPermission(sender, "commandbook.gamemode.check");
                }
                mode = player.getGameMode();
            } else {
                String modeString;
                change = true;
                if (args.argsLength() == 1) {
                    modeString = args.getString(0);
                    player = PlayerUtil.checkPlayer(sender);
                } else {
                    player = PlayerUtil.matchSinglePlayer(sender, args.getString(0));
                    modeString = args.getString(1);
                }
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.gamemode.change.other");
                } else {
                    CommandBook.inst().checkPermission(sender, "commandbook.gamemode.change");
                }
                try {
                    mode = GameMode.valueOf((String)modeString.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    try {
                        mode = GameMode.getByValue((int)Integer.parseInt(modeString));
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
                if (mode == null) {
                    throw new CommandException("Unrecognized gamemode: " + modeString + ".");
                }
            }
            if (player == null || mode == null) {
                throw new CommandException("\u0427\u0442\u043e-\u0442\u043e \u043f\u043e\u0448\u043b\u043e \u043d\u0435 \u0442\u0430\u043a, \u043f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0435\u0449\u0435 \u0440\u0430\u0437.");
            }
            if (change) {
                if (player.getGameMode() == mode) {
                    message = " \u0443\u0436\u0435 \u0431\u044b\u043b \u0440\u0435\u0436\u0438\u043c \u0438\u0433\u0440\u044b " + mode.toString();
                    change = false;
                } else {
                    message = " \u0438\u0433\u0440\u043e\u0432\u043e\u0439 \u0440\u0435\u0436\u0438\u043c \u0438\u0437\u043c\u0435\u043d\u0451\u043d " + mode.toString();
                }
            } else {
                message = " \u0432 \u043d\u0430\u0441\u0442\u043e\u044f\u0449\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u0440\u0435\u0436\u0438\u043c \u0438\u0433\u0440\u044b " + mode.toString();
            }
            if (change) {
                player.setGameMode(mode);
            }
            sender.sendMessage(ChatColor.YELLOW + "\u0418\u0433\u0440\u043e\u043a " + (CommandBook.inst().useDisplayNames ? player.getDisplayName() : player.getName()) + ChatColor.YELLOW + message + ".");
        }

        @Command(aliases={"heal"}, usage="[player]", desc="Heal a player", flags="s", min=0, max=1)
        @CommandPermissions(value={"commandbook.heal", "commandbook.heal.other"})
        public void heal(CommandContext args, CommandSender sender) throws CommandException {
            Iterable<Player> targets = null;
            boolean included = false;
            if (args.argsLength() == 0) {
                targets = PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
            } else if (args.argsLength() == 1) {
                targets = PlayerUtil.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.heal.other");
                    continue;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.heal");
            }
            for (Player player : targets) {
                player.setHealth(20);
                player.setFoodLevel(20);
                if (player.equals(sender)) {
                    player.sendMessage(ChatColor.YELLOW + "\u0412\u044b\u043b\u0435\u0447\u0435\u043d!");
                    included = true;
                    continue;
                }
                player.sendMessage(ChatColor.YELLOW + "\u0412\u044b\u043b\u0435\u0447\u0435\u043d \u043e\u0442 " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
            }
            if (!included && args.hasFlag('s')) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "\u0418\u0433\u0440\u043e\u043a\u0438 \u0432\u044b\u043b\u0435\u0447\u0435\u043d\u044b.");
            }
        }

        @Command(aliases={"slay"}, usage="[player]", desc="Slay a player", flags="s", min=0, max=1)
        @CommandPermissions(value={"commandbook.slay"})
        public void slay(CommandContext args, CommandSender sender) throws CommandException {
            Iterable<Player> targets = null;
            boolean included = false;
            if (args.argsLength() == 0) {
                targets = PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
            } else if (args.argsLength() == 1) {
                targets = PlayerUtil.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.slay.other");
                    continue;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.slay");
            }
            for (Player player : targets) {
                player.setHealth(0);
                if (player.equals(sender)) {
                    player.sendMessage(ChatColor.YELLOW + "\u0421\u043b\u0438\u0442!");
                    included = true;
                    continue;
                }
                player.sendMessage(ChatColor.YELLOW + "\u0421\u043b\u0438\u0442 \u043e\u0442" + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
            }
            if (!included && args.hasFlag('s')) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "\u0418\u0433\u0440\u043e\u043a\u0438 \u0441\u043b\u0438\u0442\u044b.");
            }
        }

        @Command(aliases={"locate"}, usage="[player]", desc="Locate a player", max=1)
        @CommandPermissions(value={"commandbook.locate"})
        public void locate(CommandContext args, CommandSender sender) throws CommandException {
            Player player = PlayerUtil.checkPlayer(sender);
            if (args.argsLength() == 0) {
                player.setCompassTarget(player.getWorld().getSpawnLocation());
                sender.sendMessage(ChatColor.YELLOW.toString() + "\u041a\u043e\u043c\u043f\u0430\u0441 \u0441\u0431\u0440\u043e\u0448\u0435\u043d \u043d\u0430 \u0441\u043f\u0430\u0432\u043d.");
            } else {
                Player target = PlayerUtil.matchSinglePlayer(sender, args.getString(0));
                player.setCompassTarget(target.getLocation());
                sender.sendMessage(ChatColor.YELLOW.toString() + "Compass repointed.");
            }
        }
    }
}

