/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.session.SessionComponent;
import com.sk89q.commandbook.util.PlayerUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.Depend;
import com.zachsthings.libcomponents.InjectComponent;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import com.zachsthings.libcomponents.config.ConfigurationBase;
import com.zachsthings.libcomponents.config.Setting;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

@ComponentInformation(friendlyName="Thor", desc="Thor's hammer and other lightning effects.")
@Depend(components={SessionComponent.class})
public class ThorComponent
extends BukkitComponent
implements Listener {
    @InjectComponent
    private SessionComponent sessions;
    private LocalConfiguration config;
    private static final Random random = new Random();

    public void enable() {
        this.config = this.configure(new LocalConfiguration());
        CommandBook.registerEvents(this);
        this.registerCommands(Commands.class);
    }

    public void reload() {
        super.reload();
        this.configure(this.config);
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (this.sessions.getSession((CommandSender)player).hasThor()) {
            if (!this.config.thorItems.contains(player.getItemInHand().getTypeId())) {
                return;
            }
            if (event.getAction() == Action.LEFT_CLICK_AIR) {
                Block block = player.getTargetBlock(null, 300);
                if (block != null) {
                    player.getWorld().strikeLightning(block.getLocation());
                }
            } else if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
                Block block = event.getClickedBlock();
                player.getWorld().strikeLightning(block.getLocation());
            }
        }
    }

    public class Commands {
        @Command(aliases={"shock"}, usage="[target]", desc="Shock a player", flags="ksa", min=0, max=1)
        @CommandPermissions(value={"commandbook.shock"})
        public void shock(CommandContext args, CommandSender sender) throws CommandException {
            Iterable<Player> targets = null;
            boolean included = false;
            int count = 0;
            if (args.argsLength() == 0) {
                targets = PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
            } else if (args.argsLength() == 1) {
                targets = PlayerUtil.matchPlayers(sender, args.getString(0));
            }
            for (final Player player : targets) {
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.shock.other");
                    continue;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.shock");
            }
            for (final Player player : targets) {
                ++count;
                if (args.hasFlag('a')) {
                    final Location origLoc = player.getLocation();
                    for (int i = 0; i < 10; ++i) {
                        CommandBook.server().getScheduler().scheduleSyncDelayedTask((Plugin)CommandBook.inst(), new Runnable(){

                            public void run() {
                                Location loc = origLoc.clone();
                                loc.setX(loc.getX() + random.nextDouble() * 20.0 - 10.0);
                                loc.setZ(loc.getZ() + random.nextDouble() * 20.0 - 10.0);
                                player.getWorld().strikeLightning(loc);
                            }
                        }, (long)Math.max(0, i * 3 + random.nextInt(10) - 5));
                    }
                } else {
                    player.getWorld().strikeLightning(player.getLocation());
                }
                if (args.hasFlag('k')) {
                    player.setHealth(0);
                }
                if (args.hasFlag('s')) {
                    if (player.equals(sender)) {
                        player.sendMessage(ChatColor.YELLOW + "\u0412 \u0448\u043e\u043a\u0435!");
                        included = true;
                        continue;
                    }
                    player.sendMessage(ChatColor.YELLOW + "\u0412\u044b \u0431\u044b\u043b\u0438 \u0448\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u044b " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
                    continue;
                }
                if (count < 6) {
                    CommandBook.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " \u0448\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d " + PlayerUtil.toColoredName((CommandSender)player, ChatColor.YELLOW));
                    continue;
                }
                if (count != 6) continue;
                CommandBook.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " \u0448\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u043e \u043c\u043d\u043e\u0433\u043e \u043b\u044e\u0434\u0435\u0439 ...");
            }
            if (!included && args.hasFlag('s')) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "\u0418\u0433\u0440\u043e\u043a\u0438 \u0432 \u0448\u043e\u043a\u0435.");
            }
        }

        @Command(aliases={"thor"}, usage="[target]", desc="Give a player Thor power", flags="", min=0, max=1)
        @CommandPermissions(value={"commandbook.thor"})
        public void thor(CommandContext args, CommandSender sender) throws CommandException {
            Iterable<Player> targets = null;
            boolean included = false;
            if (args.argsLength() == 0) {
                targets = PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
            } else if (args.argsLength() == 1) {
                targets = PlayerUtil.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.thor.other");
                    continue;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.thor");
            }
            for (Player player : targets) {
                ThorComponent.this.sessions.getSession((CommandSender)player).setHasThor(true);
                if (player.equals(sender)) {
                    player.sendMessage(ChatColor.YELLOW + "\u0412\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u0438 \u043c\u043e\u0433\u0443\u0447\u0443\u044e \u0441\u0438\u043b\u0443 \u043c\u043e\u043b\u043e\u0442\u0430 \u0422\u043e\u0440\u0430!");
                    included = true;
                    continue;
                }
                player.sendMessage(ChatColor.YELLOW + "\u0412\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u0438 \u043c\u043e\u0433\u0443\u0449\u0435\u0441\u0442\u0432\u043e \u0441\u0438\u043b\u044b \u043c\u043e\u043b\u043e\u0442 \u0422\u043e\u0440\u0430 \u043e\u0442 " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
            }
            if (!included && args.hasFlag('s')) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "\u0418\u0433\u0440\u043e\u043a\u0438 \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u0438 \u043c\u043e\u043b\u043e\u0442 \u0422\u043e\u0440\u0430.");
            }
        }

        @Command(aliases={"unthor"}, usage="[target]", desc="Revoke a player's Thor power", flags="", min=0, max=1)
        @CommandPermissions(value={"commandbook.thor"})
        public void unthor(CommandContext args, CommandSender sender) throws CommandException {
            Iterable<Player> targets = null;
            boolean included = false;
            if (args.argsLength() == 0) {
                targets = PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
            } else if (args.argsLength() == 1) {
                targets = PlayerUtil.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.thor.other");
                    continue;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.thor");
            }
            for (Player player : targets) {
                ThorComponent.this.sessions.getSession((CommandSender)player).setHasThor(false);
                if (player.equals(sender)) {
                    player.sendMessage(ChatColor.YELLOW + "\u0412\u044b \u043f\u043e\u0442\u0435\u0440\u044f\u043b\u0438 \u043c\u043e\u043b\u043e\u0442 \u0422\u043e\u0440\u0430!");
                    included = true;
                    continue;
                }
                player.sendMessage(ChatColor.YELLOW + "\u041c\u043e\u043b\u043e\u0442 \u0422\u043e\u0440\u0430 \u0431\u044b\u043b \u043e\u0442\u043e\u0437\u0432\u0430\u043d \u043e\u0442 \u0432\u0430\u0441 \u043e\u0442" + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
            }
            if (!included && args.hasFlag('s')) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "\u041c\u043e\u043b\u043e\u0442 \u0422\u043e\u0440\u0430 \u043e\u0442\u043e\u0437\u0432\u0430\u043d \u0438\u0437 \u0438\u0433\u0440\u043e\u043a\u043e\u0432.");
            }
        }
    }

    private static class LocalConfiguration
    extends ConfigurationBase {
        @Setting(value="hammer-items")
        public Set<Integer> thorItems = new HashSet<Integer>(Arrays.asList(278, 285, 257, 270));

        private LocalConfiguration() {
        }
    }
}

