/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.util.LocationUtil;
import com.sk89q.commandbook.util.PlayerUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

@ComponentInformation(friendlyName="World Tools", desc="Various world-related commands.")
public class WorldComponent
extends BukkitComponent {
    public void enable() {
        this.registerCommands(Commands.class);
    }

    public class Commands {
        @Command(aliases={"weather"}, usage="<'stormy'|'sunny'> [duration] [world]", desc="Change the world weather", min=1, max=3)
        @CommandPermissions(value={"commandbook.weather"})
        public void weather(CommandContext args, CommandSender sender) throws CommandException {
            World world;
            String weatherStr = args.getString(0);
            int duration = -1;
            if (args.argsLength() == 1) {
                world = PlayerUtil.checkPlayer(sender).getWorld();
            } else if (args.argsLength() == 2) {
                world = PlayerUtil.checkPlayer(sender).getWorld();
                duration = args.getInteger(1);
            } else {
                world = LocationUtil.matchWorld(sender, args.getString(2));
                duration = args.getInteger(1);
            }
            if (weatherStr.equalsIgnoreCase("stormy") || weatherStr.equalsIgnoreCase("rainy") || weatherStr.equalsIgnoreCase("snowy") || weatherStr.equalsIgnoreCase("rain") || weatherStr.equalsIgnoreCase("snow") || weatherStr.equalsIgnoreCase("on")) {
                world.setStorm(true);
                if (duration > 0) {
                    world.setWeatherDuration(duration * 20);
                }
                if (CommandBook.inst().broadcastChanges) {
                    CommandBook.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " \u0432\u044b\u0437\u0432\u0430\u043b \u0448\u0442\u043e\u0440\u043c \u0432 '" + world.getName() + "'.");
                }
                if (!CommandBook.inst().broadcastChanges) {
                    sender.sendMessage(ChatColor.YELLOW + "\u0428\u0442\u043e\u0440\u043c\u043e\u0432\u0430\u044f \u043f\u043e\u0433\u043e\u0434\u0430 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430.");
                }
            } else if (weatherStr.equalsIgnoreCase("clear") || weatherStr.equalsIgnoreCase("sunny") || weatherStr.equalsIgnoreCase("snowy") || weatherStr.equalsIgnoreCase("rain") || weatherStr.equalsIgnoreCase("snow") || weatherStr.equalsIgnoreCase("off")) {
                world.setStorm(false);
                if (duration > 0) {
                    world.setWeatherDuration(duration * 20);
                }
                if (CommandBook.inst().broadcastChanges) {
                    CommandBook.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u043b \u0448\u0442\u043e\u0440\u043c \u0432 '" + world.getName() + "'.");
                }
                if (!CommandBook.inst().broadcastChanges) {
                    sender.sendMessage(ChatColor.YELLOW + "\u0428\u0442\u043e\u0440\u043c\u043e\u0432\u0430\u044f \u043f\u043e\u0433\u043e\u0434\u0430 \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u0430.");
                }
            } else {
                throw new CommandException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043f\u043e\u0433\u043e\u0434\u044b! \u041f\u0440\u0438\u0435\u043c\u043b\u0435\u043c\u044b\u0435 \u0433\u043b\u0430\u0441\u0438\u0442: \u0441\u043e\u043b\u043d\u0435\u0447\u043d\u043e \u0438\u043b\u0438 \u0431\u0443\u0440\u043d\u044b\u0439");
            }
        }

        @Command(aliases={"thunder"}, usage="<'on'|'off'> [duration] [world]", desc="Change the thunder state", min=1, max=3)
        @CommandPermissions(value={"commandbook.weather.thunder"})
        public void thunder(CommandContext args, CommandSender sender) throws CommandException {
            World world;
            String weatherStr = args.getString(0);
            int duration = -1;
            if (args.argsLength() == 1) {
                world = PlayerUtil.checkPlayer(sender).getWorld();
            } else if (args.argsLength() == 2) {
                world = PlayerUtil.checkPlayer(sender).getWorld();
                duration = args.getInteger(1);
            } else {
                world = LocationUtil.matchWorld(sender, args.getString(2));
                duration = args.getInteger(1);
            }
            if (weatherStr.equalsIgnoreCase("on")) {
                world.setThundering(true);
                if (duration > 0) {
                    world.setThunderDuration(duration * 20);
                }
                sender.sendMessage(ChatColor.YELLOW + "\u0413\u0440\u043e\u043c \u0432\u043a\u043b\u044e\u0447\u0435\u043d.");
            } else if (weatherStr.equalsIgnoreCase("off")) {
                world.setThundering(false);
                if (duration > 0) {
                    world.setThunderDuration(duration * 20);
                }
                sender.sendMessage(ChatColor.YELLOW + "\u0413\u0440\u043e\u043c \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d.");
            } else {
                throw new CommandException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0433\u0440\u043e\u043c\u0430! \u041f\u0440\u0438\u0435\u043c\u043b\u0435\u043c\u044b\u0435: \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u0438\u043b\u0438 \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u043e");
            }
        }
    }
}

