/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.kits;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.kits.FlatFileKitsManager;
import com.sk89q.commandbook.kits.GarbageCollector;
import com.sk89q.commandbook.kits.Kit;
import com.sk89q.commandbook.kits.KitManager;
import com.sk89q.commandbook.util.PlayerUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import java.io.File;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@ComponentInformation(friendlyName="Kits", desc="Distributes kits to players on command (with cooldowns)")
public class KitsComponent
extends BukkitComponent {
    private KitManager kits;

    public void enable() {
        CommandBook.inst().createDefaultConfiguration("kits.txt");
        this.kits = new FlatFileKitsManager(new File(CommandBook.inst().getDataFolder(), "kits.txt"));
        this.kits.load();
        CommandBook.server().getScheduler().scheduleAsyncRepeatingTask((Plugin)CommandBook.inst(), (Runnable)new GarbageCollector(this), 12000L, 12000L);
        this.registerCommands(Commands.class);
    }

    public void reload() {
        super.reload();
        this.kits.load();
    }

    public KitManager getKitManager() {
        return this.kits;
    }

    public class Commands {
        @Command(aliases={"kit"}, usage="<id> [target]", desc="Get a kit", flags="", min=0, max=2)
        public void kit(CommandContext args, CommandSender sender) throws CommandException {
            if (args.argsLength() == 0) {
                CommandBook.inst().checkPermission(sender, "commandbook.kit.list");
                Map<String, Kit> kits = KitsComponent.this.getKitManager().getKits();
                if (kits.size() == 0) {
                    throw new CommandException("\u042d\u0442\u043e\u0442 \u043a\u043e\u043c\u043f\u043b\u0435\u043a\u0442 \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d.");
                }
                StringBuilder str = new StringBuilder();
                int count = 0;
                for (String id : kits.keySet()) {
                    if (!CommandBook.inst().hasPermission(sender, "commandbook.kit.kits." + id.replace(".", ""))) continue;
                    if (str.length() != 0) {
                        str.append(", ");
                    }
                    str.append(id);
                    ++count;
                }
                if (count == 0) {
                    throw new CommandException("\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u043a\u043e\u043c\u043f\u043b\u0435\u043a\u0442\u0430\u043c.");
                }
                sender.sendMessage(ChatColor.YELLOW + "Kits (" + count + "): " + ChatColor.WHITE + str.toString());
                sender.sendMessage(ChatColor.YELLOW + "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 /kit <\u0438\u043c\u044f \u043a\u043e\u043c\u043f\u043b\u0435\u043a\u0442\u0430>, \u0447\u0442\u043e\u0431\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043a\u043e\u043c\u043f\u043b\u0435\u043a\u0442.");
            } else {
                String id = args.getString(0).toLowerCase();
                boolean included = false;
                Iterable<Player> targets = args.argsLength() == 2 ? PlayerUtil.matchPlayers(sender, args.getString(1)) : PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
                for (Player player : targets) {
                    if (player == sender) continue;
                    CommandBook.inst().checkPermission(sender, "commandbook.kit.other");
                }
                Kit kit = KitsComponent.this.getKitManager().getKit(id);
                if (kit == null) {
                    throw new CommandException("\u041a\u043e\u043c\u043f\u043b\u0435\u043a\u0442 \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
                }
                CommandBook.inst().checkPermission(sender, "commandbook.kit.kits." + id.replace(".", ""));
                for (Player player : targets) {
                    boolean success = kit.distribute(player);
                    if (player.equals(sender)) {
                        if (success) {
                            player.sendMessage(ChatColor.YELLOW + "\u041a\u043e\u043c\u043f\u043b\u0435\u043a\u0442 '" + id + "' \u0432\u044b\u0434\u0430\u043d!");
                        } else {
                            player.sendMessage(ChatColor.RED + "\u0412\u0430\u043c \u043f\u0440\u0438\u0434\u0435\u0442\u0441\u044f \u043f\u043e\u0434\u043e\u0436\u0434\u0430\u0442\u044c, \u043f\u0440\u0435\u0436\u0434\u0435 \u0447\u0435\u043c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u043d\u0430\u0431\u043e\u0440 \u0435\u0449\u0435 \u0440\u0430\u0437.");
                        }
                        included = true;
                        continue;
                    }
                    if (success) {
                        player.sendMessage(ChatColor.YELLOW + "\u0412\u044b \u0434\u0430\u043b\u0438 " + "'" + id + "' \u043a\u043e\u043c\u043f\u043b\u0435\u043a\u0442 \u043e\u0442" + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
                        continue;
                    }
                    player.sendMessage(ChatColor.RED + "\u041a\u043e\u043c\u043f\u043b\u0435\u043a\u0442 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u0432\u0430\u043c, \u043f\u043e\u0442\u043e\u043c\u0443 \u0447\u0442\u043e \u044d\u0442\u043e \u0431\u044b\u043b\u043e \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0440\u0430\u043d\u043e.");
                }
                if (!included) {
                    sender.sendMessage(ChatColor.YELLOW + "\u041a\u043e\u043c\u043f\u043b\u0435\u043a\u0442\u044b \u0432\u044b\u0434\u0430\u043d\u044b.");
                }
            }
        }
    }
}

