/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.locations;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.session.SessionComponent;
import com.sk89q.commandbook.session.UserSession;
import com.sk89q.commandbook.util.LocationUtil;
import com.sk89q.commandbook.util.PlayerUtil;
import com.sk89q.commandbook.util.TeleportPlayerIterator;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.Depend;
import com.zachsthings.libcomponents.InjectComponent;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

@ComponentInformation(friendlyName="Teleports", desc="Teleport-related commands")
@Depend(components={SessionComponent.class})
public class TeleportComponent
extends BukkitComponent
implements Listener {
    @InjectComponent
    private SessionComponent sessions;

    public void enable() {
        CommandBook.registerEvents(this);
        this.registerCommands(Commands.class);
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        this.sessions.getSession(UserSession.class, (CommandSender)event.getPlayer()).rememberLocation(event.getPlayer());
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent event) {
        Location loc = event.getTo();
        Player player = event.getPlayer();
        if (event.isCancelled()) {
            return;
        }
        if (loc == this.sessions.getSession(UserSession.class, (CommandSender)player).getIgnoreLocation()) {
            this.sessions.getSession(UserSession.class, (CommandSender)player).setIgnoreLocation(null);
            return;
        }
        this.sessions.getSession(UserSession.class, (CommandSender)player).rememberLocation(event.getPlayer());
    }

    public class Commands {
        @Command(aliases={"teleport", "tp"}, usage="[target] <destination>", desc="Teleport to a location", flags="s", min=1, max=2)
        @CommandPermissions(value={"commandbook.teleport"})
        public void teleport(CommandContext args, CommandSender sender) throws CommandException {
            Location loc;
            Iterable<Player> targets;
            block2: {
                block1: {
                    if (args.argsLength() != 1) break block1;
                    targets = PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
                    loc = LocationUtil.matchLocation(sender, args.getString(0));
                    if (!(sender instanceof Player)) break block2;
                    CommandBook.inst().checkPermission(sender, loc.getWorld(), "commandbook.teleport");
                    break block2;
                }
                targets = PlayerUtil.matchPlayers(sender, args.getString(0));
                loc = LocationUtil.matchLocation(sender, args.getString(1));
                for (Player target : targets) {
                    if (target == sender) continue;
                    CommandBook.inst().checkPermission(sender, "commandbook.teleport.other");
                    if (!(sender instanceof Player)) break;
                    CommandBook.inst().checkPermission(sender, loc.getWorld(), "commandbook.teleport.other");
                    break;
                }
            }
            new TeleportPlayerIterator(sender, loc, args.hasFlag('s')).iterate(targets);
        }

        @Command(aliases={"call"}, usage="<target>", desc="Request a teleport", min=1, max=1)
        @CommandPermissions(value={"commandbook.call"})
        public void requestTeleport(CommandContext args, CommandSender sender) throws CommandException {
            Player player = PlayerUtil.checkPlayer(sender);
            Player target = PlayerUtil.matchSinglePlayer(sender, args.getString(0));
            CommandBook.inst().checkPermission(sender, target.getWorld(), "commandbook.call");
            TeleportComponent.this.sessions.getSession(UserSession.class, (CommandSender)player).checkLastTeleportRequest(target);
            TeleportComponent.this.sessions.getSession(UserSession.class, (CommandSender)target).addBringable(player);
            sender.sendMessage(ChatColor.YELLOW.toString() + "Teleport request sent.");
            target.sendMessage(ChatColor.AQUA + "**TELEPORT** " + PlayerUtil.toColoredName(sender, ChatColor.AQUA) + " \u0437\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0442\u0435\u043b\u0435\u043f\u043e\u0440\u0442! \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 /bring <\u0438\u043c\u044f> , \u0447\u0442\u043e\u0431\u044b \u043f\u0440\u0438\u043d\u044f\u0442\u044c.");
        }

        @Command(aliases={"bring", "tphere", "summon", "s"}, usage="<target>", desc="Bring a player to you", min=1, max=1)
        public void bring(CommandContext args, CommandSender sender) throws CommandException {
            Player player = PlayerUtil.checkPlayer(sender);
            if (!CommandBook.inst().hasPermission(sender, "commandbook.teleport.other")) {
                Player target = PlayerUtil.matchSinglePlayer(sender, args.getString(0));
                if (!TeleportComponent.this.sessions.getSession(UserSession.class, (CommandSender)player).isBringable(target)) {
                    throw new CommandException("\u042d\u0442\u043e\u0442 \u0438\u0433\u0440\u043e\u043a \u043d\u0435 \u043f\u0440\u043e\u0441\u0438\u043b \u0442\u0435\u043b\u0435\u043f\u043e\u0440\u0442(\u043d\u0435\u0434\u0430\u0432\u043d\u043e), \u0438 \u0443 \u0432\u0430\u0441 \u043d\u0435\u0442 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u044f \u043d\u0430 \u0442\u0435\u043b\u0435\u043f\u043e\u0440\u0442\u0430\u0446\u0438\u044e \u0432\u0441\u0435\u0445.");
                }
                sender.sendMessage(ChatColor.YELLOW + "\u0418\u0433\u0440\u043e\u043a \u0442\u0435\u043b\u0435\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043b\u0441\u044f");
                target.sendMessage(ChatColor.YELLOW + "\u0412\u0430\u0448 \u0442\u0435\u043b\u0435\u043f\u043e\u0440\u0442 \u0437\u0430\u043f\u0440\u043e\u0448\u0435\u043d " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " \u0431\u044b\u043b\u043e \u043f\u0440\u0438\u043d\u044f\u0442\u043e");
                target.teleport((Entity)player);
                return;
            }
            Iterable<Player> targets = PlayerUtil.matchPlayers(sender, args.getString(0));
            Location loc = player.getLocation();
            new TeleportPlayerIterator(sender, loc){

                public void perform(Player player) {
                    if (this.sender instanceof Player && !player.getWorld().getName().equals(((Player)this.sender).getWorld().getName()) && !CommandBook.inst().hasPermission(this.sender, player.getWorld(), "commandbook.teleport.other")) {
                        return;
                    }
                    this.oldLoc = player.getLocation();
                    player.teleport(this.loc);
                }
            }.iterate(targets);
        }

        @Command(aliases={"put", "place"}, usage="<target>", desc="Put a player at where you are looking", min=1, max=1)
        @CommandPermissions(value={"commandbook.teleport.other"})
        public void put(CommandContext args, CommandSender sender) throws CommandException {
            Iterable<Player> targets = PlayerUtil.matchPlayers(sender, args.getString(0));
            Location loc = LocationUtil.matchLocation(sender, "#target");
            new TeleportPlayerIterator(sender, loc){

                public void perform(Player player) {
                    this.oldLoc = player.getLocation();
                    Location playerLoc = player.getLocation();
                    this.loc.setPitch(playerLoc.getPitch());
                    this.loc.setYaw(playerLoc.getYaw());
                    player.teleport(this.loc);
                }
            }.iterate(targets);
        }

        @Command(aliases={"return", "ret"}, usage="[player]", desc="Teleport back to your last location", min=0, max=1)
        @CommandPermissions(value={"commandbook.return"})
        public void ret(CommandContext args, CommandSender sender) throws CommandException {
            Location lastLoc;
            Player player;
            if (args.argsLength() > 0) {
                player = PlayerUtil.matchSinglePlayer(sender, args.getString(0));
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.return.other");
                }
            } else {
                player = PlayerUtil.checkPlayer(sender);
            }
            if ((lastLoc = TeleportComponent.this.sessions.getSession(UserSession.class, (CommandSender)player).popLastLocation()) != null) {
                TeleportComponent.this.sessions.getSession(UserSession.class, (CommandSender)player).setIgnoreLocation(lastLoc);
                player.teleport(lastLoc);
                sender.sendMessage(ChatColor.YELLOW + "\u0412\u044b \u0431\u044b\u043b\u0438 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0435\u043d\u044b.");
            } else {
                sender.sendMessage(ChatColor.RED + "\u0422\u0430\u043c \u043d\u0435\u0442 \u043f\u0440\u043e\u0448\u043b\u043e\u0433\u043e \u043c\u0435\u0441\u0442\u0430 \u0432 \u0438\u0441\u0442\u043e\u0440\u0438\u0438.");
            }
        }
    }
}

