/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.session;

import com.zachsthings.libcomponents.config.ConfigurationBase;
import com.zachsthings.libcomponents.config.Setting;
import java.util.concurrent.TimeUnit;
import org.bukkit.command.CommandSender;

public abstract class PersistentSession
extends ConfigurationBase {
    public static final long THIRTY_MINUTES = TimeUnit.MINUTES.toMillis(30L);
    public static final long ONE_HOUR = TimeUnit.HOURS.toMillis(1L);
    private final long maxTime;
    @Setting(value="last-update")
    private long lastUpdate;
    private CommandSender sender;
    private String senderName;

    protected PersistentSession(long maxTime) {
        this.maxTime = maxTime;
    }

    public long getGoneTime() {
        return System.currentTimeMillis() - this.lastUpdate;
    }

    public boolean isRecent() {
        return this.maxTime == -1L || this.getGoneTime() < this.maxTime;
    }

    public CommandSender getOwner() {
        return this.sender;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public void handleDisconnect() {
        this.lastUpdate = System.currentTimeMillis();
        this.sender = null;
    }

    public void handleReconnect(CommandSender sender) {
        if (sender == null) {
            throw new IllegalArgumentException("\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044c \u043d\u0435 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c!");
        }
        this.sender = sender;
        this.senderName = sender.getName();
    }
}

