/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.time;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.CommandBookUtil;
import com.sk89q.commandbook.time.TimeLocker;
import com.sk89q.commandbook.util.LocationUtil;
import com.sk89q.commandbook.util.PlayerUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import com.zachsthings.libcomponents.config.ConfigurationBase;
import com.zachsthings.libcomponents.config.Setting;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentInformation(friendlyName="Time Control", desc="Commands to manage and lock time for a world.")
public class TimeComponent
extends BukkitComponent
implements Listener {
    protected static final Pattern TWELVE_HOUR_TIME = Pattern.compile("^([0-9]+(?::[0-9]+)?)([apmAPM\\.]+)$");
    protected final Map<String, Integer> tasks = new HashMap<String, Integer>();
    protected final Map<String, Integer> lockedTimes = new HashMap<String, Integer>();
    protected LocalConfiguration config;

    @Override
    public void enable() {
        this.config = this.configure(new LocalConfiguration());
        if (this.config.timeLockDelay == 0) {
            this.config.timeLockDelay = 20;
            this.saveConfig(this.config);
        }
        this.configureWorldLocks();
        this.registerCommands(Commands.class);
        CommandBook.registerEvents(this);
    }

    private void configureWorldLocks() {
        if (this.config.timeLocks != null) {
            for (Map.Entry<String, Object> entry : this.config.timeLocks.entrySet()) {
                int time = 0;
                try {
                    time = this.matchTime(String.valueOf(entry.getValue()));
                }
                catch (CommandException e) {
                    CommandBook.logger().warning("\u0411\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0430 \u0432\u0440\u0435\u043c\u0435\u043d\u0438: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u0432\u0440\u0435\u043c\u044f '" + entry.getValue() + "'");
                    continue;
                }
                this.lockedTimes.put(entry.getKey(), time);
                World world = CommandBook.server().getWorld(entry.getKey());
                if (world == null) {
                    CommandBook.logger().info("\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0435\u0442 \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0438 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0445 \u0432 \u043c\u0438\u0440\u0435 '" + entry.getKey() + "'");
                    continue;
                }
                world.setTime((long)time);
                this.lock(world);
                CommandBook.logger().info("\u0412\u0440\u0435\u043c\u044f \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u043e '" + CommandBookUtil.getTimeString(time) + "' \u0432 \u043c\u0438\u0440\u0435 '" + world.getName() + "'");
            }
        }
    }

    @Override
    public void reload() {
        super.reload();
        this.configureWorldLocks();
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        World world = event.getWorld();
        Integer lockedTime = this.getLockedTimes().get(world.getName());
        if (lockedTime != null) {
            world.setTime((long)lockedTime.intValue());
            this.lock(world);
            CommandBook.logger().info("\u0412\u0440\u0435\u043c\u044f \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u043e '" + CommandBookUtil.getTimeString(lockedTime.intValue()) + "' \u0432 \u043c\u0438\u0440\u0435 '" + world.getName() + "'");
        }
    }

    @EventHandler
    public void onWorldUnload(WorldUnloadEvent event) {
        this.unlock(event.getWorld());
    }

    public Map<String, Integer> getLockedTimes() {
        return this.lockedTimes;
    }

    public synchronized void unlock(World world) {
        Integer id = this.tasks.get(world.getName());
        if (id != null) {
            CommandBook.server().getScheduler().cancelTask(id.intValue());
        }
    }

    public synchronized void lock(World world) {
        long time = world.getFullTime();
        this.unlock(world);
        int id = CommandBook.server().getScheduler().scheduleSyncRepeatingTask((Plugin)CommandBook.inst(), (Runnable)new TimeLocker(world, time), 20L, (long)this.config.timeLockDelay);
        this.tasks.put(world.getName(), id);
    }

    public int matchTime(String timeStr) throws CommandException {
        try {
            int time = Integer.parseInt(timeStr);
            if (time <= 24) {
                return (time - 8) % 24 * 1000;
            }
            return time;
        }
        catch (NumberFormatException e) {
            if (timeStr.matches("^*[0-9]+$")) {
                return Integer.parseInt(timeStr.substring(1));
            }
            if (timeStr.matches("^[0-9]+:[0-9]+$")) {
                String[] parts = timeStr.split(":");
                int hours = Integer.parseInt(parts[0]);
                int mins = Integer.parseInt(parts[1]);
                return (int)((long)((hours - 8) % 24 * 1000) + Math.round((double)(mins % 60) / 60.0 * 1000.0));
            }
            Matcher matcher = TWELVE_HOUR_TIME.matcher(timeStr);
            if (matcher.matches()) {
                int shift;
                String time = matcher.group(1);
                String period = matcher.group(2);
                if (period.equalsIgnoreCase("am") || period.equalsIgnoreCase("a.m.")) {
                    shift = 0;
                } else if (period.equalsIgnoreCase("pm") || period.equalsIgnoreCase("p.m.")) {
                    shift = 12;
                } else {
                    throw new CommandException("'am' or 'pm' expected, got '" + period + "'.");
                }
                String[] parts = time.split(":");
                int hours = Integer.parseInt(parts[0]);
                int mins = parts.length >= 2 ? Integer.parseInt(parts[1]) : 0;
                return (int)((double)((hours % 12 + shift - 8) % 24 * 1000) + (double)(mins % 60) / 60.0 * 1000.0);
            }
            if (timeStr.equalsIgnoreCase("dawn")) {
                return 22000;
            }
            if (timeStr.equalsIgnoreCase("sunrise")) {
                return 23000;
            }
            if (timeStr.equalsIgnoreCase("morning")) {
                return 24000;
            }
            if (timeStr.equalsIgnoreCase("day")) {
                return 24000;
            }
            if (timeStr.equalsIgnoreCase("noon") || timeStr.equalsIgnoreCase("noon")) {
                return 28000;
            }
            if (timeStr.equalsIgnoreCase("afternoon")) {
                return 30000;
            }
            if (timeStr.equalsIgnoreCase("evening")) {
                return 32000;
            }
            if (timeStr.equalsIgnoreCase("sunset")) {
                return 37000;
            }
            if (timeStr.equalsIgnoreCase("twilight")) {
                return 37500;
            }
            if (timeStr.equalsIgnoreCase("night")) {
                return 38000;
            }
            if (timeStr.equalsIgnoreCase("midnight")) {
                return 16000;
            }
            throw new CommandException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0432\u0440\u0435\u043c\u0435\u043d\u0438.");
        }
    }

    public class Commands {
        @Command(aliases={"time"}, usage="[world] <time|\"current\">", desc="Get/change the world time", flags="l", min=0, max=2)
        public void time(CommandContext args, CommandSender sender) throws CommandException {
            String timeStr;
            World world;
            boolean onlyLock = false;
            if (args.argsLength() == 0) {
                world = PlayerUtil.checkPlayer(sender).getWorld();
                timeStr = "current";
            } else if (args.argsLength() == 1) {
                world = PlayerUtil.checkPlayer(sender).getWorld();
                timeStr = args.getString(0);
            } else {
                world = LocationUtil.matchWorld(sender, args.getString(0));
                timeStr = args.getString(1);
            }
            if (timeStr.equalsIgnoreCase("current") || timeStr.equalsIgnoreCase("cur") || timeStr.equalsIgnoreCase("now")) {
                if (!args.hasFlag('l')) {
                    CommandBook.inst().checkPermission(sender, "commandbook.time.check");
                    sender.sendMessage(ChatColor.YELLOW + "\u0412\u0440\u0435\u043c\u044f:" + CommandBookUtil.getTimeString(world.getTime()));
                    return;
                }
                onlyLock = true;
            }
            CommandBook.inst().checkPermission(sender, "commandbook.time");
            if (!onlyLock) {
                TimeComponent.this.unlock(world);
                world.setTime((long)TimeComponent.this.matchTime(timeStr));
            }
            String verb = "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e";
            if (args.hasFlag('l')) {
                CommandBook.inst().checkPermission(sender, "commandbook.time.lock");
                TimeComponent.this.lock(world);
                verb = "locked";
            }
            if (CommandBook.inst().broadcastChanges) {
                CommandBook.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " " + verb + " \u0432\u0440\u0435\u043c\u044f '" + world.getName() + "' \u043d\u0430 " + CommandBookUtil.getTimeString(world.getTime()) + ".");
            } else {
                sender.sendMessage(ChatColor.YELLOW + "Time " + verb + " to " + CommandBookUtil.getTimeString(world.getTime()) + ".");
            }
        }

        @Command(aliases={"playertime"}, usage="[filter] <time|\"current\">", desc="Get/change a player's time", flags="rsw", min=0, max=2)
        public void playertime(CommandContext args, CommandSender sender) throws CommandException {
            Iterable<Player> players = null;
            String timeStr = "current";
            boolean included = false;
            boolean reset = args.hasFlag('r');
            if (args.argsLength() < 2) {
                if (args.argsLength() == 1) {
                    timeStr = args.getString(0);
                    if (reset) {
                        players = PlayerUtil.matchPlayers(sender, timeStr);
                    }
                }
                if (players == null) {
                    players = PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
                }
            } else {
                players = PlayerUtil.matchPlayers(sender, args.getString(0));
                timeStr = args.getString(1);
            }
            for (Player player : players) {
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.time.player.other");
                    break;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.time.player");
            }
            if (args.hasFlag('r')) {
                for (Player player : players) {
                    player.resetPlayerTime();
                    if (!args.hasFlag('s')) {
                        player.sendMessage(ChatColor.YELLOW + "\u0412\u0430\u0448\u0435 \u0432\u0440\u0435\u043c\u044f, \u0447\u0442\u043e\u0431\u044b \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043c\u0438\u0440\u043e\u0432\u043e\u0435 \u0432\u0440\u0435\u043c\u044f");
                    }
                    if (!(sender instanceof Player) || !sender.equals(player)) continue;
                    included = true;
                }
                if (!included) {
                    sender.sendMessage(ChatColor.YELLOW + "\u0421\u0431\u0440\u043e\u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u0438\u0433\u0440\u043e\u043a\u0430");
                }
                return;
            }
            if (timeStr.equalsIgnoreCase("current") || timeStr.equalsIgnoreCase("cur") || timeStr.equalsIgnoreCase("now")) {
                CommandBook.inst().checkPermission(sender, "commandbook.time.player.check");
                sender.sendMessage(ChatColor.YELLOW + "Player Time: " + CommandBookUtil.getTimeString(PlayerUtil.matchSinglePlayer(sender, args.getString(0, PlayerUtil.checkPlayer(sender).getName())).getPlayerTime()));
                return;
            }
            for (Player player : players) {
                if (!player.equals(sender)) {
                    player.sendMessage(ChatColor.YELLOW + "\u0412\u0430\u0448\u0435 \u0432\u0440\u0435\u043c\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u043d\u0430" + CommandBookUtil.getTimeString(player.getPlayerTime()));
                } else {
                    player.sendMessage(ChatColor.YELLOW + "\u0412\u0430\u0448\u0435 \u0432\u0440\u0435\u043c\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u043d\u0430" + CommandBookUtil.getTimeString(player.getPlayerTime()));
                    included = true;
                }
                player.setPlayerTime(args.hasFlag('w') ? (long)Integer.parseInt(timeStr) : (long)TimeComponent.this.matchTime(timeStr), args.hasFlag('w'));
            }
            if (!included) {
                sender.sendMessage(ChatColor.YELLOW + "\u0412\u0440\u0435\u043c\u044f \u0438\u0433\u0440\u043e\u043a\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u043d\u0430" + CommandBookUtil.getTimeString(TimeComponent.this.matchTime(timeStr)));
            }
        }
    }

    private static class LocalConfiguration
    extends ConfigurationBase {
        @Setting(value="time-lock")
        public Map<String, Object> timeLocks;
        @Setting(value="time-lock-delay")
        public int timeLockDelay = 20;

        private LocalConfiguration() {
        }
    }
}

