/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.util;

import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.blocks.ClothColor;
import com.sk89q.worldedit.blocks.ItemType;
import java.util.Random;
import org.bukkit.DyeColor;

public class ItemUtil {
    public static String toItemName(int id) {
        ItemType type = ItemType.fromID((int)id);
        if (type != null) {
            return type.getName();
        }
        return "#" + id;
    }

    public static int matchItemData(int id, String filter) throws CommandException {
        try {
            return Integer.parseInt(filter);
        }
        catch (NumberFormatException e) {
            switch (id) {
                case 5: {
                    if (filter.equalsIgnoreCase("redwood")) {
                        return 1;
                    }
                    if (filter.equalsIgnoreCase("birch")) {
                        return 2;
                    }
                    throw new CommandException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u0438\u043c\u044f \u0442\u0438\u043f\u0430 \u0434\u0440\u0435\u0432\u0438\u0441\u0438\u043d\u044b '" + filter + "'.");
                }
                case 43: 
                case 44: {
                    BlockType dataType = BlockType.lookup((String)filter);
                    if (dataType != null) {
                        if (dataType == BlockType.STONE) {
                            return 0;
                        }
                        if (dataType == BlockType.SANDSTONE) {
                            return 1;
                        }
                        if (dataType == BlockType.WOOD) {
                            return 2;
                        }
                        if (dataType == BlockType.COBBLESTONE) {
                            return 3;
                        }
                        throw new CommandException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b \u043f\u043b\u0438\u0442\u044b '" + filter + "'.");
                    }
                    throw new CommandException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b \u043f\u043b\u0438\u0442\u044b '" + filter + "'.");
                }
                case 35: {
                    ClothColor col = ClothColor.lookup((String)filter);
                    if (col != null) {
                        return col.getID();
                    }
                    throw new CommandException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0446\u0432\u0435\u0442 \u0448\u0435\u0440\u0441\u0442\u0438 '" + filter + "'.");
                }
                case 351: {
                    ClothColor dyeCol = ClothColor.lookup((String)filter);
                    if (dyeCol != null) {
                        return 15 - dyeCol.getID();
                    }
                    throw new CommandException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u0438\u043c\u044f \u043a\u0440\u0430\u0441\u0438\u0442\u0435\u043b\u044f '" + filter + "'.");
                }
            }
            throw new CommandException("\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 '" + filter + "'.");
        }
    }

    public static DyeColor matchDyeColor(String filter) throws CommandException {
        if (filter.equalsIgnoreCase("random")) {
            return DyeColor.getByData((byte)((byte)new Random().nextInt(15)));
        }
        try {
            DyeColor match = DyeColor.valueOf((String)filter.toUpperCase());
            if (match != null) {
                return match;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        throw new CommandException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u0438\u043c\u044f \u043a\u0440\u0430\u0441\u0438\u0442\u0435\u043b\u044f '" + filter + "'.");
    }
}

