/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.util;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.CommandBookUtil;
import com.sk89q.commandbook.locations.HomesComponent;
import com.sk89q.commandbook.locations.LocationsComponent;
import com.sk89q.commandbook.locations.NamedLocation;
import com.sk89q.commandbook.locations.RootLocationManager;
import com.sk89q.commandbook.locations.WarpsComponent;
import com.sk89q.commandbook.util.PlayerUtil;
import com.sk89q.minecraft.util.commands.CommandException;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationUtil {
    private LocationUtil() {
    }

    public static World matchWorld(CommandSender sender, String filter) throws CommandException {
        List worlds = CommandBook.server().getWorlds();
        if (filter.charAt(0) == '#') {
            if (filter.equalsIgnoreCase("#main")) {
                return (World)worlds.get(0);
            }
            if (filter.equalsIgnoreCase("#normal")) {
                for (World world : worlds) {
                    if (world.getEnvironment() != World.Environment.NORMAL) continue;
                    return world;
                }
                throw new CommandException("\u041d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u043d\u043e\u0440\u043c\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043c\u0438\u0440\u0430.");
            }
            if (filter.equalsIgnoreCase("#nether")) {
                for (World world : worlds) {
                    if (world.getEnvironment() != World.Environment.NETHER) continue;
                    return world;
                }
                throw new CommandException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0430\u0434\u0441\u043a\u0438\u0439 \u043c\u0438\u0440.");
            }
            if (filter.equalsIgnoreCase("#skylands") || filter.equalsIgnoreCase("#theend") || filter.equalsIgnoreCase("#end")) {
                World.Environment skylandsEnv = CommandBookUtil.getSkylandsEnvironment();
                for (World world : worlds) {
                    if (world.getEnvironment() != skylandsEnv) continue;
                    return world;
                }
                throw new CommandException("\u041c\u0438\u0440\u0430 skylands \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.");
            }
            if (filter.matches("^#player$")) {
                String[] parts = filter.split(":", 2);
                if (parts.length == 1) {
                    throw new CommandException("\u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u043e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u0438\u0433\u0440\u043e\u043a\u0430 #player.");
                }
                return PlayerUtil.matchPlayers(sender, parts[1]).iterator().next().getWorld();
            }
            throw new CommandException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 '" + filter + "'.");
        }
        for (World world : worlds) {
            if (!world.getName().equals(filter)) continue;
            return world;
        }
        throw new CommandException("\u041d\u0435\u0442 \u043c\u0438\u0440\u0430, \u044d\u0442\u0438\u043c \u0442\u043e\u0447\u043d\u043e\u0435 \u0438\u043c\u044f \u043d\u0430\u0439\u0434\u0435\u043d\u043e.");
    }

    public static Location matchLocation(CommandSender source, String filter) throws CommandException {
        List<Player> players;
        if (filter.matches("^[\\-0-9\\.]+,[\\-0-9\\.]+,[\\-0-9\\.]+(?:.+)?$")) {
            double z;
            double y;
            double x;
            CommandBook.inst().checkPermission(source, "commandbook.locations.coords");
            String[] args = filter.split(":");
            String[] parts = args[0].split(",");
            try {
                x = Double.parseDouble(parts[0]);
                y = Double.parseDouble(parts[1]);
                z = Double.parseDouble(parts[2]);
            }
            catch (NumberFormatException e) {
                throw new CommandException("\u041e\u0436\u0438\u0434\u0430\u044e\u0442\u0441\u044f \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b \u043d\u043e\u043c\u0435\u0440\u0430!");
            }
            if (args.length > 1) {
                return new Location(LocationUtil.matchWorld(source, args[1]), x, y, z);
            }
            Player player = PlayerUtil.checkPlayer(source);
            return new Location(player.getWorld(), x, y, z);
        }
        if (filter.charAt(0) == '#') {
            CommandBook.inst().checkPermission(source, "commandbook.spawn");
            String[] args = filter.split(":");
            if (args[0].equalsIgnoreCase("#spawn")) {
                if (args.length > 1) {
                    return LocationUtil.matchWorld(source, args[1]).getSpawnLocation();
                }
                Player sourcePlayer = PlayerUtil.checkPlayer(source);
                return sourcePlayer.getLocation().getWorld().getSpawnLocation();
            }
            if (args[0].equalsIgnoreCase("#target")) {
                Player player = PlayerUtil.checkPlayer(source);
                Location playerLoc = player.getLocation();
                Block targetBlock = player.getTargetBlock(null, 100);
                if (targetBlock == null) {
                    throw new CommandException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0431\u043b\u043e\u043a \u0432 \u0446\u0435\u043b\u0438!");
                }
                Location loc = targetBlock.getLocation();
                playerLoc.setX(loc.getX());
                playerLoc.setY(loc.getY());
                playerLoc.setZ(loc.getZ());
                return CommandBookUtil.findFreePosition(playerLoc);
            }
            if (args[0].equalsIgnoreCase("#home") || args[0].equalsIgnoreCase("#warp")) {
                LocationsComponent component;
                String type = args[0].substring(1);
                CommandBook.inst().checkPermission(source, "commandbook.locations." + type);
                LocationsComponent locationsComponent = component = type.equalsIgnoreCase("warp") ? (LocationsComponent)CommandBook.inst().getComponentManager().getComponent(WarpsComponent.class) : (LocationsComponent)CommandBook.inst().getComponentManager().getComponent(HomesComponent.class);
                if (component == null) {
                    throw new CommandException("\u042d\u0442\u043e\u0442 \u0442\u0438\u043f \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d!");
                }
                RootLocationManager<NamedLocation> manager = component.getManager();
                if (args.length == 1) {
                    if (type.equalsIgnoreCase("warp")) {
                        throw new CommandException("\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0443\u043a\u0430\u0436\u0438\u0442\u0435 \u0438\u043c\u044f \u0432\u0430\u0440\u043f\u0430.");
                    }
                    Player ply = PlayerUtil.checkPlayer(source);
                    NamedLocation loc = manager.get(ply.getWorld(), ply.getName());
                    if (loc == null) {
                        throw new CommandException("\u0412\u044b \u0435\u0449\u0451 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u043b\u0438 \u0432\u0430\u0448 \u0434\u043e\u043c.");
                    }
                    return loc.getLocation();
                }
                if (args.length == 2) {
                    Player player;
                    NamedLocation loc;
                    if (source instanceof Player && (loc = manager.get((player = (Player)source).getWorld(), args[1])) != null && !loc.getCreatorName().equalsIgnoreCase(player.getName())) {
                        CommandBook.inst().checkPermission(source, "commandbook.locations." + type + ".other");
                    }
                    return LocationUtil.getManagedLocation(manager, PlayerUtil.checkPlayer(source).getWorld(), args[1]);
                }
                if (args.length == 3) {
                    if (source instanceof Player) {
                        Player player = (Player)source;
                        NamedLocation loc = manager.get(LocationUtil.matchWorld(source, args[2]), args[1]);
                        if (loc != null && !loc.getCreatorName().equalsIgnoreCase(player.getName())) {
                            CommandBook.inst().checkPermission(source, "commandbook.locations." + type + ".other");
                        }
                    }
                    return LocationUtil.getManagedLocation(manager, LocationUtil.matchWorld(source, args[2]), args[1]);
                }
            } else {
                if (args[0].equalsIgnoreCase("#me")) {
                    return PlayerUtil.checkPlayer(source).getLocation();
                }
                throw new CommandException("Invalid group '" + filter + "'.");
            }
        }
        if ((players = PlayerUtil.matchPlayerNames(filter)).size() == 0) {
            throw new CommandException("\u041d\u0435\u0442 \u0438\u0433\u0440\u043e\u043a\u043e\u0432 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0445 \u0437\u0430\u043f\u0440\u043e\u0441\u0443.");
        }
        return players.get(0).getLocation();
    }

    public static Location getManagedLocation(RootLocationManager<NamedLocation> manager, World world, String id) throws CommandException {
        NamedLocation loc = manager.get(world, id);
        if (loc == null) {
            throw new CommandException("\u041b\u043e\u043a\u0430\u0446\u0438\u044f \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430.");
        }
        return loc.getLocation();
    }

    public static String toFriendlyString(Location location) {
        return location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ() + "@" + location.getWorld().getName();
    }
}

