/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.util;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.minecraft.util.commands.CommandException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerUtil {
    private PlayerUtil() {
    }

    public static Player checkPlayer(CommandSender sender) throws CommandException {
        if (sender instanceof Player) {
            return (Player)sender;
        }
        throw new CommandException("\u0418\u0433\u0440\u043e\u043a \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 \u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f.(\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043c\u0438\u0440 \u0438\u043b\u0438 \u0438\u0433\u0440\u043e\u043a\u0430, \u0435\u0441\u043b\u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u044d\u0442\u043e \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442.)");
    }

    public static List<Player> matchPlayerNames(String filter) {
        Player[] players = CommandBook.server().getOnlinePlayers();
        boolean useDisplayNames = CommandBook.inst().lookupWithDisplayNames;
        if ((filter = filter.toLowerCase()).charAt(0) == '@' && filter.length() >= 2) {
            filter = filter.substring(1);
            for (Player player : players) {
                if (!player.getName().equalsIgnoreCase(filter) && (!useDisplayNames || !ChatColor.stripColor((String)player.getDisplayName()).equalsIgnoreCase(filter))) continue;
                ArrayList<Player> list = new ArrayList<Player>();
                list.add(player);
                return list;
            }
            return new ArrayList<Player>();
        }
        if (filter.charAt(0) == '*' && filter.length() >= 2) {
            filter = filter.substring(1);
            ArrayList<Player> list = new ArrayList<Player>();
            for (Player player : players) {
                if (!player.getName().toLowerCase().contains(filter) && (!useDisplayNames || !ChatColor.stripColor((String)player.getDisplayName().toLowerCase()).contains(filter))) continue;
                list.add(player);
            }
            return list;
        }
        ArrayList<Player> list = new ArrayList<Player>();
        for (Player player : players) {
            if (!player.getName().toLowerCase().startsWith(filter) && (!useDisplayNames || !ChatColor.stripColor((String)player.getDisplayName().toLowerCase()).startsWith(filter))) continue;
            list.add(player);
        }
        return list;
    }

    protected static Iterable<Player> checkPlayerMatch(List<Player> players) throws CommandException {
        if (players.size() == 0) {
            throw new CommandException("\u0418\u0433\u0440\u043e\u043a\u043e\u0432 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0445 \u0437\u0430\u043f\u0440\u043e\u0441\u0443 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.");
        }
        return players;
    }

    public static Iterable<Player> matchPlayers(CommandSender source, String filter) throws CommandException {
        if (CommandBook.server().getOnlinePlayers().length == 0) {
            throw new CommandException("\u0418\u0433\u0440\u043e\u043a\u043e\u0432 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0445 \u0437\u0430\u043f\u0440\u043e\u0441\u0443 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.");
        }
        if (filter.equals("*")) {
            return PlayerUtil.checkPlayerMatch(Arrays.asList(CommandBook.server().getOnlinePlayers()));
        }
        if (filter.charAt(0) == '#') {
            if (filter.equalsIgnoreCase("#world")) {
                ArrayList<Player> players = new ArrayList<Player>();
                Player sourcePlayer = PlayerUtil.checkPlayer(source);
                World sourceWorld = sourcePlayer.getWorld();
                for (Player player : CommandBook.server().getOnlinePlayers()) {
                    if (!player.getWorld().equals(sourceWorld)) continue;
                    players.add(player);
                }
                return PlayerUtil.checkPlayerMatch(players);
            }
            if (filter.equalsIgnoreCase("#near")) {
                ArrayList<Player> players = new ArrayList<Player>();
                Player sourcePlayer = PlayerUtil.checkPlayer(source);
                World sourceWorld = sourcePlayer.getWorld();
                Vector sourceVector = sourcePlayer.getLocation().toVector();
                for (Player player : CommandBook.server().getOnlinePlayers()) {
                    if (!player.getWorld().equals(sourceWorld) || !(player.getLocation().toVector().distanceSquared(sourceVector) < 900.0)) continue;
                    players.add(player);
                }
                return PlayerUtil.checkPlayerMatch(players);
            }
            throw new CommandException("Invalid group '" + filter + "'.");
        }
        List<Player> players = PlayerUtil.matchPlayerNames(filter);
        return PlayerUtil.checkPlayerMatch(players);
    }

    public static Player matchPlayerExactly(CommandSender sender, String filter) throws CommandException {
        Player[] players;
        for (Player player : players = CommandBook.server().getOnlinePlayers()) {
            if (!player.getName().equalsIgnoreCase(filter) && (!CommandBook.inst().lookupWithDisplayNames || !player.getDisplayName().equalsIgnoreCase(filter))) continue;
            return player;
        }
        throw new CommandException("\u041d\u0438 \u043e\u0434\u0438\u043d \u0438\u0433\u0440\u043e\u043a \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
    }

    public static Player matchSinglePlayer(CommandSender sender, String filter) throws CommandException {
        Iterator<Player> players = PlayerUtil.matchPlayers(sender, filter).iterator();
        Player match = players.next();
        if (players.hasNext()) {
            throw new CommandException("\u0411\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043e\u0434\u0438\u043d \u0438\u0433\u0440\u043e\u043a\u043e\u0432 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e! \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 @<name> \u0434\u043b\u044f \u0442\u043e\u0447\u043d\u043e\u0433\u043e \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u044f.");
        }
        return match;
    }

    public static CommandSender matchPlayerOrConsole(CommandSender sender, String filter) throws CommandException {
        if (filter.equalsIgnoreCase("#console") || filter.equalsIgnoreCase("*console*") || filter.equalsIgnoreCase("!")) {
            return CommandBook.server().getConsoleSender();
        }
        return PlayerUtil.matchSinglePlayer(sender, filter);
    }

    public static Iterable<Player> matchPlayers(Player player) {
        return Arrays.asList(player);
    }

    public static String toName(CommandSender sender) {
        return ChatColor.stripColor((String)PlayerUtil.toColoredName(sender, null));
    }

    public static String toColoredName(CommandSender sender, ChatColor endColor) {
        if (sender instanceof Player) {
            String name;
            String string = name = CommandBook.inst().useDisplayNames ? ((Player)sender).getDisplayName() : sender.getName();
            if (endColor != null && name.contains("\u00a7")) {
                name = name + endColor;
            }
            return name;
        }
        if (sender instanceof ConsoleCommandSender) {
            return "*Console*";
        }
        return sender.getName();
    }

    public static String toUniqueName(CommandSender sender) {
        if (sender instanceof Player) {
            return sender.getName();
        }
        return "*Console*";
    }
}

