/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.util;

import com.sk89q.commandbook.util.PlayerIteratorAction;
import com.sk89q.commandbook.util.PlayerUtil;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeleportPlayerIterator
extends PlayerIteratorAction {
    protected final Location loc;
    protected Location oldLoc;
    protected final boolean silent;

    public TeleportPlayerIterator(CommandSender sender, Location loc) {
        this(sender, loc, false);
    }

    public TeleportPlayerIterator(CommandSender sender, Location loc, boolean silent) {
        super(sender);
        this.loc = loc;
        this.silent = silent;
    }

    public void perform(Player player) {
        this.oldLoc = player.getLocation();
        player.teleport(this.loc);
    }

    public void onCaller(Player player) {
        player.sendMessage(ChatColor.YELLOW + "\u0422\u0435\u043b\u0435\u043f\u043e\u0440\u0442\u0430\u0446\u0438\u044f.");
    }

    public void onVictim(CommandSender sender, Player player) {
        if (this.silent) {
            return;
        }
        if (this.oldLoc.getWorld().equals(this.loc.getWorld())) {
            player.sendMessage(ChatColor.YELLOW + "\u0412\u044b \u0442\u0435\u043b\u0435\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u044b \u043e\u0442" + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
        } else {
            player.sendMessage(ChatColor.YELLOW + "\u0412\u044b \u0442\u0435\u043b\u0435\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u044b \u043e\u0442" + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " \u0432 world '" + this.loc.getWorld().getName() + "'.");
        }
    }

    public void onInformMany(CommandSender sender, int affected) {
        sender.sendMessage(ChatColor.YELLOW.toString() + affected + "\u0442\u0435\u043b\u0435\u043f\u043e\u0440\u0442\u0430\u0446\u0438\u044f.");
    }
}

